/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.units;

import com.endertech.minecraft.forge.blocks.BlockStatesMap;
import com.endertech.minecraft.forge.core.AbstractForgeMod;
import com.endertech.minecraft.forge.units.IRelatedUnit;
import com.endertech.minecraft.forge.units.UnitId;
import com.endertech.minecraft.forge.units.UnitsInitWithEnum;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;

public abstract class RelatedUnitsInit<T extends IRelatedUnit, E extends Enum<?>>
extends UnitsInitWithEnum<T, E> {
    protected final BlockStatesMap<T> allBlockStates = new BlockStatesMap();
    protected final Map<Item, T> allItems = new ConcurrentHashMap<Item, T>();
    protected final Map<Fluid, T> allFluids = new ConcurrentHashMap<Fluid, T>();

    public RelatedUnitsInit(AbstractForgeMod mod, Class<E> builtIn) {
        super(mod, builtIn);
    }

    @Override
    public void onPostInit() {
        super.onPostInit();
        this.attachToStates();
    }

    protected void clearAttachedStates() {
        this.allBlockStates.clear();
        this.allItems.clear();
        this.allFluids.clear();
    }

    protected void attachToStates() {
        this.clearAttachedStates();
        this.streamAll().forEach(unit -> {
            this.attachToBlockStates(unit);
            this.attachToItemStates(unit);
            this.attachToFluids(unit);
        });
    }

    protected void attachToBlockStates(T unit) {
        UnitId id = unit.getRelatedId();
        this.allBlockStates.put(id, unit);
    }

    protected void attachToItemStates(T unit) {
        UnitId id = unit.getRelatedId();
        Collection<Item> items = id.getAllMatchedItems();
        if (items != null) {
            items.forEach(item -> this.allItems.put((Item)item, unit));
        }
    }

    protected void attachToFluids(T unit) {
        UnitId id = unit.getRelatedId();
        Collection<Fluid> fluids = id.getAllMatchedFluids();
        if (fluids != null) {
            fluids.forEach(fluid -> this.allFluids.put((Fluid)fluid, unit));
        }
    }

    public Optional<T> get(ItemStack stack) {
        return this.get(stack.getItem());
    }

    public Optional<T> get(Item item) {
        return Optional.ofNullable((IRelatedUnit)this.allItems.get(item));
    }

    public Optional<T> get(BlockState state) {
        return Optional.ofNullable((IRelatedUnit)this.allBlockStates.get(state));
    }

    public Optional<T> get(Fluid fluid) {
        return Optional.ofNullable((IRelatedUnit)this.allFluids.get(fluid));
    }
}

