function initializeCoreMod() {
	Java.type('net.minecraftforge.coremod.api.ASMAPI').loadFile('coremods/core_functions.js')

	var target = {
		'type' : 'METHOD',
		'class' : 'com/simibubi/create/content/kinetics/fan/processing/FanProcessing',
		'methodName' : 'applyProcessing', 
		'methodDesc' : '(Lnet/minecraft/world/entity/item/ItemEntity;Lcom/simibubi/create/content/kinetics/fan/processing/FanProcessingType;)Z'
	}

	var node = {
		'class' : 'net/minecraft/world/entity/item/ItemEntity',
		'methodName' : 'discard',
		'methodDesc' : '()V'
	}

	var handler = {
		'class' : 'com/endertech/minecraft/mods/adpother/compat/Create',
		'methodName' : 'handleFanProcessing',
		'methodDesc' : '(Lnet/minecraft/world/entity/item/ItemEntity;Ljava/lang/Object;)V'
	}

	var instructions = [ 
		insnLoadObj(0, "itemEntity"),
		insnLoadObj(1, "processingType"),
		insnCallHandler(handler)
	];

	return {
		'coremod' : {
			'target' : target,
			'transformer' : function(method) {
				insertInstructionsBefore(method, node, instructions);
				return method;
			}
		}
	}
}