/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.blocks;

import com.endertech.minecraft.forge.configs.IHaveConfig;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.units.UnitProperties;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.StainedGlassPaneBlock;
import net.minecraft.world.level.block.TransparentBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.Shapes;

public class ForgeBlock
extends Block
implements IHaveConfig {
    public static final AABB FULL_BLOCK_AABB = Shapes.block().bounds();
    @Nullable
    private final UnitConfig config;

    public ForgeBlock(@Nullable UnitConfig config, Properties<?> props) {
        this(config, props.vanillaProps);
    }

    public ForgeBlock(@Nullable UnitConfig config, BlockBehaviour.Properties props) {
        super(props);
        this.config = config;
    }

    public static ResourceKey<Block> getResourceKey(String modId, String blockName) {
        return ResourceKey.create((ResourceKey)Registries.BLOCK, (Identifier)Identifier.fromNamespaceAndPath((String)modId, (String)blockName));
    }

    public static Identifier getIdentifier(Block block) {
        return BuiltInRegistries.BLOCK.getKey((Object)block);
    }

    public static Identifier getIdentifier(Fluid fluid) {
        return BuiltInRegistries.FLUID.getKey((Object)fluid);
    }

    public static boolean isUnderRain(Level level, BlockPos pos) {
        return level.isRainingAt(pos.above());
    }

    public static boolean isUnderOpenSky(Level level, BlockPos pos) {
        return level.canSeeSky(pos.above());
    }

    public static boolean isLiquid(BlockState state) {
        return state.getBlock() instanceof LiquidBlock;
    }

    public static boolean isGlass(BlockState state) {
        Block block = state.getBlock();
        if (block instanceof TransparentBlock || block instanceof StainedGlassPaneBlock) {
            return true;
        }
        return !state.canOcclude() && state.getSoundType() == SoundType.GLASS;
    }

    @Override
    @Nullable
    public UnitConfig getConfig() {
        return this.config;
    }

    public static class Properties<T extends Properties<T>>
    extends UnitProperties<T> {
        public final BlockBehaviour.Properties vanillaProps;

        public static Properties<?> of(ResourceKey<Block> key) {
            return new Properties<Properties>(Properties.class, key);
        }

        protected Properties(Class<T> selfClass, ResourceKey<Block> key) {
            super(selfClass, key.identifier().getPath());
            this.vanillaProps = BlockBehaviour.Properties.of().setId(key);
        }

        public T randomTicks() {
            this.vanillaProps.randomTicks();
            return (T)((Properties)this.self);
        }

        public T noOcclusion() {
            this.vanillaProps.noOcclusion();
            return (T)((Properties)this.self);
        }
    }
}

