/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.client;

import com.endertech.minecraft.forge.ForgeEndertech;
import com.endertech.minecraft.forge.core.AbstractForgeMod;
import com.endertech.minecraft.forge.data.BaseProperties;
import com.mojang.serialization.MapCodec;
import java.lang.reflect.Field;
import javax.annotation.Nullable;
import net.minecraft.client.color.item.ItemTintSources;
import net.minecraft.client.renderer.block.model.BlockStateModel;
import net.minecraft.client.renderer.item.properties.conditional.ConditionalItemModelProperties;
import net.minecraft.client.renderer.item.properties.numeric.RangeSelectItemModelProperties;
import net.minecraft.client.renderer.item.properties.select.SelectItemModelProperties;
import net.minecraft.client.renderer.item.properties.select.SelectItemModelProperty;
import net.minecraft.client.renderer.special.SpecialModelRenderers;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.resources.Identifier;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.fml.util.ObfuscationReflectionHelper;

public class ItemModel {
    public static final String INVENTORY = "inventory";

    public static class Properties<T extends Properties<T>>
    extends BaseProperties<T> {
        protected final AbstractForgeMod mod;

        public static Properties<?> of(AbstractForgeMod mod) {
            return new Properties<Properties>(mod, Properties.class);
        }

        protected Properties(AbstractForgeMod mod, Class<T> selfClass) {
            super(selfClass);
            this.mod = mod;
        }

        public T register(Type type, String name, MapCodec<?> codec) {
            Identifier id = this.mod.getNamespace().identifier(name);
            try {
                ((ExtraCodecs.LateBoundIdMapper)type.idMapper.get(null)).put((Object)id, codec);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            return (T)((Properties)this.self);
        }

        public T register(Type type, String name, SelectItemModelProperty.Type<?, ?> codec) {
            Identifier id = this.mod.getNamespace().identifier(name);
            try {
                ((ExtraCodecs.LateBoundIdMapper)type.idMapper.get(null)).put((Object)id, codec);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            return (T)((Properties)this.self);
        }
    }

    public static enum Type {
        TINTED(ItemTintSources.class),
        RANGED(RangeSelectItemModelProperties.class),
        SELECT(SelectItemModelProperties.class),
        CONDITIONAL(ConditionalItemModelProperties.class),
        SPECIAL(SpecialModelRenderers.class);

        public final Field idMapper;

        private Type(Class<?> targetClass) {
            this.idMapper = ObfuscationReflectionHelper.findField(targetClass, (String)"ID_MAPPER");
        }
    }

    public static class RegistryWrapper {
        protected final ModelBakery.BakingResult bakingResult;

        public RegistryWrapper(ModelBakery.BakingResult bakingResult) {
            this.bakingResult = bakingResult;
        }

        @Nullable
        public BlockStateModel getModelOf(BlockState state) {
            return (BlockStateModel)this.bakingResult.blockStateModels().get(state);
        }

        public boolean replaceModelOf(BlockState state, BlockStateModel newModel) {
            return this.bakingResult.blockStateModels().put(state, newModel) != null;
        }

        public boolean replaceModelOf(BlockState state, IModelWrapperFactory newModelFactory) {
            BlockStateModel original = this.getModelOf(state);
            if (original != null) {
                return this.replaceModelOf(state, newModelFactory.create(original));
            }
            ForgeEndertech.getInstance().getLogger().error("Unable to find and replace block model for " + state.toString());
            return false;
        }
    }

    public static interface IModelWrapperFactory {
        public BlockStateModel create(BlockStateModel var1);
    }
}

