/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.compat;

import com.endertech.minecraft.forge.core.AbstractForgeMod;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.common.util.Lazy;
import net.neoforged.neoforge.items.IItemHandlerModifiable;

public final class CuriosAPI {
    private static final Lazy<Optional<CuriosAPI>> INSTANCE = AbstractForgeMod.singletonInstance("curios", CuriosAPI.class);
    private final Method getCuriosInventory;
    private final Method getEquippedCurios;
    private final Method findCurios;
    private final Method slotContext;
    private final Method slotStack;
    private final Method slotVisible;

    public static Optional<CuriosAPI> getInstance() {
        return (Optional)INSTANCE.get();
    }

    private CuriosAPI() throws ClassNotFoundException, NoSuchMethodException {
        Class<?> api = Class.forName("top.theillusivec4.curios.api.CuriosApi");
        Class<?> inventory = Class.forName("top.theillusivec4.curios.api.type.capability.ICuriosItemHandler");
        Class<?> result = Class.forName("top.theillusivec4.curios.api.SlotResult");
        Class<?> context = Class.forName("top.theillusivec4.curios.api.SlotContext");
        this.getCuriosInventory = api.getMethod("getCuriosInventory", LivingEntity.class);
        this.getEquippedCurios = inventory.getMethod("getEquippedCurios", new Class[0]);
        this.findCurios = inventory.getMethod("findCurios", Item.class);
        this.slotContext = result.getMethod("slotContext", new Class[0]);
        this.slotStack = result.getMethod("stack", new Class[0]);
        this.slotVisible = context.getMethod("visible", new Class[0]);
    }

    public List<ItemStack> findCurios(LivingEntity entity, Item item, boolean onlyVisible) {
        try {
            Object inventory = this.getCuriosInventory(entity).orElse(null);
            if (inventory != null) {
                ArrayList<ItemStack> items = new ArrayList<ItemStack>();
                for (Object result : (List)this.findCurios.invoke(inventory, item)) {
                    Object context;
                    boolean visible;
                    ItemStack stack = (ItemStack)this.slotStack.invoke(result, new Object[0]);
                    if (onlyVisible && !(visible = ((Boolean)this.slotVisible.invoke(context = this.slotContext.invoke(result, new Object[0]), new Object[0])).booleanValue())) continue;
                    items.add(stack);
                }
                return items;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Collections.emptyList();
    }

    private Optional<Object> getCuriosInventory(LivingEntity entity) throws InvocationTargetException, IllegalAccessException {
        return (Optional)this.getCuriosInventory.invoke(null, entity);
    }

    private Optional<IItemHandlerModifiable> getEquippedCurios(LivingEntity entity) throws InvocationTargetException, IllegalAccessException {
        Object inventory = this.getCuriosInventory(entity).orElse(null);
        if (inventory != null) {
            return Optional.of((IItemHandlerModifiable)this.getEquippedCurios.invoke(inventory, new Object[0]));
        }
        return Optional.empty();
    }

    public Collection<ItemStack> getAllSlots(LivingEntity entity) {
        try {
            IItemHandlerModifiable curios = this.getEquippedCurios(entity).orElse(null);
            if (curios != null) {
                ArrayList<ItemStack> slots = new ArrayList<ItemStack>();
                for (int slot = 0; slot < curios.getSlots(); ++slot) {
                    ItemStack stack = curios.getStackInSlot(slot);
                    slots.add(stack);
                }
                return slots;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Collections.emptyList();
    }
}

