/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.data;

import com.endertech.common.IntBounds;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.data.Names;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.neoforged.neoforge.transfer.energy.EnergyHandler;
import net.neoforged.neoforge.transfer.transaction.SnapshotJournal;
import net.neoforged.neoforge.transfer.transaction.Transaction;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;

public class ForgeEnergy {
    public static final String NAME = "ForgeEnergy";

    public static class Storage
    implements EnergyHandler {
        protected final SnapshotJournal energyJournal = new SnapshotJournal<Integer>(){

            protected Integer createSnapshot() {
                return energy;
            }

            protected void revertToSnapshot(Integer snapshot) {
                energy = snapshot;
            }

            protected void onRootCommit(Integer originalState) {
                int previousAmount = originalState;
                if (energy != previousAmount) {
                    // empty if block
                }
            }
        };
        protected boolean enabled;
        protected int capacity;
        protected int consumption;
        protected int energy;

        protected Storage(StorageProps props) {
            this(props, 0);
        }

        public Storage(StorageProps props, int energy) {
            this.enabled = props.enabled;
            this.capacity = props.capacity;
            this.consumption = props.consumption;
            this.energy = energy;
        }

        public static Storage empty() {
            return new Storage(StorageProps.EMPTY);
        }

        public static Storage with(StorageProps props) {
            return new Storage(props);
        }

        public Storage set(StorageProps props) {
            this.enabled = props.enabled;
            this.capacity = props.capacity;
            this.consumption = props.consumption;
            this.energy = this.correctedEnergy(this.energy);
            return this;
        }

        public boolean hasEnoughEnergy() {
            return this.getAmountAsInt() >= this.getConsumption();
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public int getConsumption() {
            return this.consumption;
        }

        public int insert(int amount, TransactionContext transaction) {
            int maxInsert = Math.min(this.capacity - this.energy, this.consumption);
            int inserted = Math.min(maxInsert, amount);
            if (inserted > 0) {
                this.energy += inserted;
                this.energyJournal.updateSnapshots(transaction);
                return inserted;
            }
            return 0;
        }

        public int extract(int amount, TransactionContext transaction) {
            int maxExtract = Math.min(this.energy, this.consumption);
            int extracted = Math.min(maxExtract, amount);
            if (extracted > 0) {
                this.energy -= extracted;
                this.energyJournal.updateSnapshots(transaction);
                return extracted;
            }
            return 0;
        }

        public int consumeEnergy() {
            if (this.isEnabled()) {
                try (Transaction transaction = Transaction.openRoot();){
                    int consumed = this.extract(this.consumption, (TransactionContext)transaction);
                    if (consumed > 0) {
                        transaction.commit();
                        int n = consumed;
                        return n;
                    }
                }
            }
            return 0;
        }

        public long getAmountAsLong() {
            return this.energy;
        }

        public long getCapacityAsLong() {
            return this.capacity;
        }

        protected int correctedEnergy(int energy) {
            return IntBounds.between(0, this.getCapacityAsInt()).enclose(energy);
        }

        public void readFrom(CompoundTag compound) {
            compound.getCompound(ForgeEnergy.NAME).ifPresent(this::deserialize);
        }

        public void readFrom(ValueInput input) {
            input.read(ForgeEnergy.NAME, CompoundTag.CODEC).ifPresent(this::deserialize);
        }

        protected void deserialize(CompoundTag tag) {
            this.enabled = tag.getBooleanOr("enabled", false);
            this.capacity = tag.getIntOr("capacity", 0);
            this.consumption = tag.getIntOr("consumption", 0);
            this.energy = this.correctedEnergy(tag.getIntOr("energy", 0));
        }

        public void writeTo(CompoundTag compound) {
            compound.put(ForgeEnergy.NAME, (Tag)this.serialize());
        }

        public void writeTo(ValueOutput output) {
            output.store(ForgeEnergy.NAME, CompoundTag.CODEC, (Object)this.serialize());
        }

        protected CompoundTag serialize() {
            CompoundTag tag = new CompoundTag();
            tag.putBoolean("enabled", this.isEnabled());
            tag.putInt("capacity", this.getCapacityAsInt());
            tag.putInt("consumption", this.getConsumption());
            tag.putInt("energy", this.getAmountAsInt());
            return tag;
        }
    }

    public static class StorageProps {
        public static final StorageProps EMPTY = new StorageProps(null, "", false, 0, 0);
        public static final IntBounds CAPACITY_BOUNDS = IntBounds.between(0, 100000);
        public static final IntBounds CONSUMPTION_BOUNDS = IntBounds.between(0, 1000);
        public final boolean enabled;
        public final int capacity;
        public final int consumption;

        protected StorageProps(UnitConfig config, String headCategory, boolean enabled, int capacity, int consumption) {
            String category = Names.dotted().join(headCategory, ForgeEnergy.NAME);
            this.enabled = UnitConfig.getBool(config, category, "enabled", enabled, "Whether Forge Energy is required or not");
            this.capacity = UnitConfig.getInt(config, category, "capacity", capacity, CAPACITY_BOUNDS, "Maximum amount of energy that can be held");
            this.consumption = UnitConfig.getInt(config, category, "consumption", consumption, CONSUMPTION_BOUNDS, "Amount of energy consumed per operation or second");
        }

        public static StorageProps create(boolean enabled, int capacity, int consumption) {
            return new StorageProps(null, "", enabled, capacity, consumption);
        }

        public static StorageProps create(UnitConfig config, String headCategory, boolean enabled, int capacity, int consumption) {
            return new StorageProps(config, headCategory, enabled, capacity, consumption);
        }
    }
}

