/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.data;

import com.endertech.minecraft.forge.data.ResourceType;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import org.apache.http.HttpEntity;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.util.EntityUtils;

class ResponseContent {
    static final int ERROR_CODE = -1;
    final URI location;
    final ResourceType type;
    final String status;
    final int code;
    final byte[] data;

    static ResponseContent of(URI location, ResourceType type, CloseableHttpResponse response) {
        Optional<StatusLine> statusLine = Optional.ofNullable(response.getStatusLine());
        String status = statusLine.map(StatusLine::toString).orElse("");
        int code = statusLine.map(StatusLine::getStatusCode).orElse(0);
        try {
            HttpEntity entity = response.getEntity();
            byte[] data = EntityUtils.toByteArray((HttpEntity)entity);
            return new ResponseContent(location, type, status, code, data);
        }
        catch (IOException e) {
            return ResponseContent.error(location, type, e);
        }
    }

    static ResponseContent empty(URI location, ResourceType type) {
        return new ResponseContent(location, type, "EMPTY", 0, new byte[0]);
    }

    static ResponseContent cached(ResponseContent content) {
        return content.withStatus("CACHED");
    }

    static ResponseContent skipped(URI location, ResourceType type) {
        return ResponseContent.empty(location, type).withStatus("SKIPPED");
    }

    static ResponseContent error(URI location, ResourceType type, Exception exception) {
        return ResponseContent.empty(location, type).withStatusCode(exception.getMessage(), -1);
    }

    ResponseContent(URI location, ResourceType type, String status, int code, byte[] data) {
        this.location = location;
        this.type = type;
        this.status = status;
        this.code = code;
        this.data = data;
    }

    boolean isStatusOK() {
        return this.code == 200;
    }

    boolean isEmpty() {
        return this.data.length == 0;
    }

    String dataAsString() {
        return new String(this.data, StandardCharsets.UTF_8);
    }

    ResponseContent withNoData() {
        return new ResponseContent(this.location, this.type, this.status, this.code, new byte[0]);
    }

    ResponseContent withStatus(String status) {
        return this.withStatusCode(status, this.code);
    }

    ResponseContent withStatusCode(String status, int code) {
        return new ResponseContent(this.location, this.type, status, code, this.data);
    }

    public String toString() {
        return "ResponseContent{location=" + String.valueOf(this.location) + ", type=" + String.valueOf((Object)this.type) + ", status='" + this.status + "', code=" + this.code + ", data=" + this.dataAsString() + "}";
    }
}

