/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.entities;

import com.endertech.common.CommonTime;
import com.endertech.minecraft.forge.configs.ColorARGB;
import com.endertech.minecraft.forge.math.GameTime;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;

public abstract class ForgeEffect
extends MobEffect {
    public static MobEffectInstance createInstance(Holder<MobEffect> effectHolder, CommonTime.Interval duration, boolean visible) {
        int ticks = (int)GameTime.inServerTicks(duration);
        return new MobEffectInstance(effectHolder, ticks, 0, false, visible);
    }

    protected ForgeEffect(MobEffectCategory type, ColorARGB liquidColor) {
        super(type, liquidColor.getARGB());
    }

    public abstract boolean applyEffectTick(ServerLevel var1, LivingEntity var2, int var3);

    public boolean shouldApplyEffectTickThisTick(int ticksLeft, int amplifier) {
        int reminder = ticksLeft % this.getUpdateInterval();
        return reminder == 0;
    }

    public int getUpdateInterval() {
        return 5;
    }
}

