/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.items;

import com.endertech.minecraft.forge.configs.IHaveConfig;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.units.UnitProperties;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.FuelValues;

public class ForgeItem
extends Item
implements IHaveConfig {
    private final UnitConfig config;

    public ForgeItem(UnitConfig config, Properties<?> properties) {
        super(properties.vanillaProps);
        this.config = config;
    }

    @Override
    public UnitConfig getConfig() {
        return this.config;
    }

    public void inventoryTickClient(ItemStack stack, Level level, Entity entity, @Nullable EquipmentSlot slot) {
    }

    public static ResourceKey<Item> getResourceKey(String modId, String itemName) {
        return ResourceKey.create((ResourceKey)Registries.ITEM, (Identifier)Identifier.fromNamespaceAndPath((String)modId, (String)itemName));
    }

    public static Identifier getIdentifier(Item item) {
        return BuiltInRegistries.ITEM.getKey((Object)item);
    }

    public static int getMaxBurnTime(ItemStack stack, FuelValues fuelValues) {
        return IntStream.of(stack.getBurnTime(RecipeType.BLASTING, fuelValues), stack.getBurnTime(RecipeType.CAMPFIRE_COOKING, fuelValues), stack.getBurnTime(RecipeType.SMELTING, fuelValues), stack.getBurnTime(RecipeType.SMOKING, fuelValues)).max().orElse(0);
    }

    public static void hurtNotDestroy(ItemStack stack, int damage, @Nullable ServerLevel level, @Nullable ServerPlayer player, Consumer<Item> onBroken) {
        if (stack.isDamageableItem() && ForgeItem.notBroken(stack) && (player == null || !player.hasInfiniteMaterials())) {
            if (damage > 0 && level != null && (damage = EnchantmentHelper.processDurabilityChange((ServerLevel)level, (ItemStack)stack, (int)damage)) <= 0) {
                return;
            }
            int newDamage = stack.getDamageValue() + damage;
            if (player != null && damage != 0) {
                CriteriaTriggers.ITEM_DURABILITY_CHANGED.trigger(player, stack, newDamage);
            }
            stack.setDamageValue(newDamage);
            if (newDamage >= stack.getMaxDamage()) {
                onBroken.accept(stack.getItem());
            }
        }
    }

    public static boolean isBroken(ItemStack stack) {
        return stack.isDamageableItem() && stack.getDamageValue() >= stack.getMaxDamage();
    }

    public static boolean notBroken(ItemStack stack) {
        return !ForgeItem.isBroken(stack);
    }

    public static Optional<Integer> indexIn(Inventory inventory, Predicate<ItemStack> predicate) {
        int size = inventory.getContainerSize();
        for (int i = 0; i < size; ++i) {
            if (!predicate.test(inventory.getItem(i))) continue;
            return Optional.of(i);
        }
        return Optional.empty();
    }

    public static class Properties<T extends Properties<T>>
    extends UnitProperties<T> {
        public final Item.Properties vanillaProps;

        public static Properties<?> of(ResourceKey<Item> key) {
            return new Properties<Properties>(Properties.class, key);
        }

        protected Properties(Class<T> selfClass, ResourceKey<Item> key) {
            super(selfClass, key.identifier().getPath());
            this.vanillaProps = new Item.Properties().setId(key);
        }
    }
}

