/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.network;

import com.endertech.minecraft.forge.network.ForgeNetMsg;
import com.endertech.minecraft.forge.tiles.ForgeTile;
import com.endertech.minecraft.forge.world.GameWorld;
import com.mojang.logging.LogUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.ValueInput;
import org.slf4j.Logger;

public class TileSharedDataMsg
extends ForgeNetMsg<TileSharedDataMsg> {
    private static final Logger LOGGER = LogUtils.getLogger();
    public CompoundTag compound;
    public BlockPos pos;

    public TileSharedDataMsg() {
    }

    public TileSharedDataMsg(CompoundTag compound, BlockPos pos) {
        this.compound = compound;
        this.pos = pos;
    }

    @Override
    public TileSharedDataMsg create() {
        return new TileSharedDataMsg();
    }

    @Override
    public void handle(Level level, Player player) {
        if (!GameWorld.isBlockLoaded((LevelReader)level, this.pos)) {
            return;
        }
        BlockEntity tileEntity = level.getBlockEntity(this.pos);
        if (tileEntity instanceof ForgeTile) {
            ForgeTile tile = (ForgeTile)tileEntity;
            try (ProblemReporter.ScopedCollector collector = new ProblemReporter.ScopedCollector(tile.problemPath(), LOGGER);){
                ValueInput input = TagValueInput.create((ProblemReporter)collector, (HolderLookup.Provider)level.registryAccess(), (CompoundTag)this.compound);
                tile.readSharedData(input);
            }
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                tile.setChanged();
                this.sendToAllObservingChunk(serverLevel, this.pos);
            }
        }
    }
}

