/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.units;

import com.endertech.minecraft.forge.core.AbstractForgeMod;
import com.endertech.minecraft.forge.units.UnitsInit;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.neoforged.neoforge.common.util.Lazy;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.RegisterEvent;

public class RegistryObjectsInit<O>
extends UnitsInit<O> {
    protected final ResourceKey<? extends Registry<O>> registryKey;
    protected final DeferredRegister<O> deferredRegister;

    public RegistryObjectsInit(AbstractForgeMod mod, Registry<O> registry) {
        this(mod, registry.key());
    }

    protected RegistryObjectsInit(AbstractForgeMod mod, ResourceKey<? extends Registry<O>> registryKey) {
        super(mod);
        this.registryKey = registryKey;
        this.deferredRegister = DeferredRegister.create(registryKey, (String)mod.getId());
        this.deferredRegister.register(mod.getModEventBus());
        mod.getModEventBus().addListener(event -> {
            if (registryKey.equals(event.getRegistryKey())) {
                this.onRegistration((RegisterEvent)event);
            }
        });
    }

    protected ResourceKey<O> resourceKey(String name) {
        return ResourceKey.create(this.registryKey, (Identifier)this.getMod().getNamespace().identifier(name));
    }

    public <U extends O> DeferredHolder<O, U> register(String name, Supplier<U> supplier) {
        Lazy<U> unit = this.addUnit(name, supplier);
        return this.deferredRegister.register(name, unit);
    }

    public <U extends O> DeferredHolder<O, U> register(String name, Function<ResourceKey<O>, U> resourceKeyToUnit) {
        return this.register(name, () -> resourceKeyToUnit.apply(this.resourceKey(name)));
    }

    public <U extends O, RO> DeferredHolder<O, U> register(DeferredHolder<? super RO, RO> registryObject, BiFunction<ResourceKey<O>, RO, U> keyAndObjectToUnit) {
        String name = registryObject.getId().getPath();
        return this.register(name, () -> keyAndObjectToUnit.apply(this.resourceKey(name), registryObject.get()));
    }

    protected void onRegistration(RegisterEvent event) {
    }
}

