/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.blocks;

import com.endertech.minecraft.mods.adpother.AdPother;
import com.endertech.minecraft.mods.adpother.blocks.Pollutant;
import com.endertech.minecraft.mods.adpother.init.Pollutants;
import java.util.Collection;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.neoforged.neoforge.fluids.BaseFlowingFluid;

public class PollutedWater
extends LiquidBlock {
    public PollutedWater(ResourceKey<Block> key) {
        super((FlowingFluid)AdPother.getInstance().fluids.pollutedWaterStill.get(), BlockBehaviour.Properties.of().setId(key).mapColor(MapColor.WATER).replaceable().noCollision().strength(100.0f).pushReaction(PushReaction.DESTROY).noLootTable().liquid().sound(SoundType.EMPTY));
    }

    public static boolean isPollutedWith(Pollutant<?> pollutant, BlockGetter level, BlockPos pos, BlockState state) {
        PollutedWater water;
        Block block = state.getBlock();
        return block instanceof PollutedWater && (water = (PollutedWater)block).isPollutedWith(pollutant, state);
    }

    public static boolean isSource(BlockGetter level, BlockPos pos) {
        BlockState state = level.getBlockState(pos);
        return state.getBlock() instanceof PollutedWater && state.getFluidState().isSource();
    }

    public static Optional<Pollutant<?>> findPollutant(BlockGetter level, BlockPos pos, Collection<Pollutant<?>> pollutants) {
        BlockState state = level.getBlockState(pos);
        for (Pollutant<?> pollutant : pollutants) {
            if (!PollutedWater.isPollutedWith(pollutant, level, pos, state)) continue;
            return Optional.of(pollutant);
        }
        return Optional.empty();
    }

    public boolean isPollutedWith(Pollutant<?> pollutant, BlockState state) {
        return pollutant == Pollutants.BuiltIn.SULFUR.get();
    }

    public boolean isCleanWaterSource(BlockState state) {
        return state.getBlock() instanceof LiquidBlock && !(state.getBlock() instanceof PollutedWater) && state.getFluidState().isSource() && state.getFluidState().is(FluidTags.WATER);
    }

    public boolean tryPollute(ServerLevel level, BlockPos pos, BlockState state) {
        if (this.isCleanWaterSource(state) && !this.isCleanWaterSource(level.getBlockState(pos.above()))) {
            return level.setBlockAndUpdate(pos, this.defaultBlockState());
        }
        return false;
    }

    public static class Flowing
    extends PollutedFluid {
        public Flowing(BaseFlowingFluid.Properties properties) {
            super(properties);
            this.registerDefaultState((FluidState)((FluidState)this.stateDefinition.any()).setValue((Property)LEVEL, (Comparable)Integer.valueOf(7)));
        }

        protected void createFluidStateDefinition(StateDefinition.Builder<Fluid, FluidState> builder) {
            super.createFluidStateDefinition(builder);
            builder.add(new Property[]{LEVEL});
        }

        public int getAmount(FluidState state) {
            return (Integer)state.getValue((Property)LEVEL);
        }

        public boolean isSource(FluidState state) {
            return false;
        }
    }

    public static class Still
    extends PollutedFluid {
        public Still(BaseFlowingFluid.Properties properties) {
            super(properties);
        }

        public boolean isSource(FluidState state) {
            return true;
        }

        public int getAmount(FluidState state) {
            return 8;
        }
    }

    public static abstract class PollutedFluid
    extends BaseFlowingFluid {
        protected PollutedFluid(BaseFlowingFluid.Properties properties) {
            super(properties);
        }

        public boolean canBeReplacedWith(FluidState state, BlockGetter world, BlockPos pos, Fluid fluid, Direction direction) {
            return super.canBeReplacedWith(state, world, pos, fluid, direction);
        }

        protected void spreadTo(LevelAccessor worldIn, BlockPos pos, BlockState blockStateIn, Direction direction, FluidState fluidStateIn) {
            super.spreadTo(worldIn, pos, blockStateIn, direction, fluidStateIn);
        }
    }
}

