/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.compat;

import com.endertech.minecraft.forge.blocks.ForgeBlock;
import com.endertech.minecraft.forge.network.ForgeNetMsg;
import com.endertech.minecraft.mods.adpother.events.WorldEvents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.Identifier;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;

public class ImmersivePetroleum {

    public static class FuelConsumedMsg
    extends ForgeNetMsg<FuelConsumedMsg> {
        public int entityId = 0;
        public String fuelName = "";
        public int consumed = 0;

        public FuelConsumedMsg() {
        }

        public FuelConsumedMsg(Entity entity, FluidStack fuel, int consumed) {
            this.entityId = entity.getId();
            this.fuelName = ForgeBlock.getIdentifier((Fluid)fuel.getFluid()).toString();
            this.consumed = consumed;
        }

        public FuelConsumedMsg create() {
            return new FuelConsumedMsg();
        }

        public void handle(Level level, Player player) {
            if (level.isClientSide()) {
                return;
            }
            Entity entity = level.getEntity(this.entityId);
            if (entity == null) {
                return;
            }
            Identifier fuelId = Identifier.tryParse((String)this.fuelName);
            if (fuelId == null) {
                return;
            }
            Fluid fuel = BuiltInRegistries.FLUID.getOptional(fuelId).orElse(null);
            if (fuel == null) {
                return;
            }
            WorldEvents.onFuelBurned(fuel, this.consumed, entity, WorldEvents.Alignment.BACK);
        }
    }

    public static class Motorboat {
        public static final void onFuelBurned(Entity boat, FluidStack fuelNow, FluidStack fuelBefore) {
            int consumed = fuelBefore.getAmount() - fuelNow.getAmount();
            if (consumed <= 0) {
                return;
            }
            if (boat.level().isClientSide()) {
                new FuelConsumedMsg(boat, fuelNow, consumed).sendToServer();
            }
        }
    }
}

