/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.config;

import com.endertech.common.Args;
import com.endertech.minecraft.forge.blocks.BlockStatesMap;
import com.endertech.minecraft.forge.configs.AbstractParsableList;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.math.Percentage;
import com.endertech.minecraft.forge.units.UnitId;
import com.endertech.minecraft.mods.adpother.config.BlockImpactList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;

public class FluidImpactList
extends AbstractParsableList {
    protected final BlockStatesMap<BlockImpactList.AbstractAction> impactsCommon = new BlockStatesMap();
    protected final BlockStatesMap<BlockStatesMap<BlockImpactList.AbstractAction>> impactsByFluid = new BlockStatesMap();

    public FluidImpactList(UnitConfig config, String category, String key, String[] defaultValues) {
        super(config, category, key, defaultValues);
    }

    protected String getComment() {
        return "Action syntax: blockId -> ACTION\nReplacement syntax: blockId -> blockId\nReplacement with copying of all properties: blockId -> blockId:*\nSyntax for a specific fluid: fluidId -> blockId -> ACTION or blockId\nPossible actions (case sensitive): " + Args.join((Object[])Arrays.stream(BlockImpactList.ActionType.values()).filter(type -> type != BlockImpactList.ActionType.REPLACE).toArray()) + "\n";
    }

    public boolean contains(FluidState fluid) {
        return this.impactsByFluid.containsKey((Object)fluid.createLegacyBlock());
    }

    public Optional<BlockImpactList.AbstractAction> getCommonAction(BlockState state) {
        return Optional.ofNullable((BlockImpactList.AbstractAction)this.impactsCommon.get((Object)state));
    }

    public Optional<BlockImpactList.AbstractAction> getActionFor(FluidState fluid, BlockState block) {
        return Optional.ofNullable((BlockStatesMap)this.impactsByFluid.get((Object)fluid.createLegacyBlock())).map(impacts -> (BlockImpactList.AbstractAction)impacts.get((Object)block));
    }

    protected void addImpact(UnitId fluidId, UnitId blockId, BlockImpactList.AbstractAction action) {
        if (fluidId.isEmpty()) {
            this.impactsCommon.put(blockId, (Object)action);
        } else {
            Collection fluids;
            BlockStatesMap impacts = new BlockStatesMap();
            impacts.put(blockId, (Object)action);
            if (fluidId.isTag() && (fluids = fluidId.getAllMatchedFluids()) != null) {
                for (Fluid fluid : fluids) {
                    Block block = fluid.defaultFluidState().createLegacyBlock().getBlock();
                    if (block == Blocks.AIR) continue;
                    this.impactsByFluid.getBlocksWithAllStates().put(block, impacts);
                }
            }
            this.impactsByFluid.put(fluidId, (Object)impacts);
        }
    }

    public void listFluids(List<String> list) {
        this.impactsByFluid.keySet().forEach(state -> list.add(state.toString()));
        this.impactsByFluid.getBlocksWithAllStates().keySet().forEach(block -> list.add(block.toString()));
    }

    protected void parseConfigValues() {
        this.impactsCommon.clear();
        this.impactsByFluid.clear();
        for (String string : this.configValues) {
            List split = this.split(string, "->");
            if (split.size() == 2) {
                split.add(0, "");
            }
            try {
                if (split.size() != 3) {
                    throw new Exception();
                }
                UnitId fluidId = UnitId.from((String)((String)split.get(0)));
                UnitId blockId = UnitId.from((String)((String)split.get(1)));
                if (blockId.isEmpty()) {
                    throw new Exception();
                }
                String arg3 = (String)split.get(2);
                if (arg3.equals(arg3.toUpperCase(Locale.ROOT))) {
                    BlockImpactList.ActionType action = BlockImpactList.ActionType.valueOf(arg3);
                    this.addImpact(fluidId, blockId, action.create(Percentage.ZERO, Optional.empty()));
                    continue;
                }
                UnitId replacementId = UnitId.from((String)arg3);
                if (replacementId.isEmpty()) {
                    throw new Exception();
                }
                BlockState matchedState = replacementId.getFirstMatchedState();
                if (matchedState == null) continue;
                boolean copyProperties = replacementId.getMetaData().equals("*");
                BlockImpactList.Replacement replacement = new BlockImpactList.Replacement(matchedState, copyProperties);
                this.addImpact(fluidId, blockId, BlockImpactList.ActionType.REPLACE.create(Percentage.ZERO, Optional.of(replacement)));
            }
            catch (Exception e) {
                this.logParsingError(string);
            }
        }
    }
}

