/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.entities;

import com.endertech.common.CommonMath;
import com.endertech.common.CommonTime;
import com.endertech.common.FloatBounds;
import com.endertech.minecraft.forge.blocks.IPollutant;
import com.endertech.minecraft.forge.math.GameTime;
import com.endertech.minecraft.forge.world.BiomeId;
import com.endertech.minecraft.forge.world.GameWorld;
import com.endertech.minecraft.mods.adpother.AdPother;
import com.endertech.minecraft.mods.adpother.blocks.Pollutant;
import com.endertech.minecraft.mods.adpother.entities.AbstractCarrier;
import com.endertech.minecraft.mods.adpother.impacts.AbstractPollutionImpacts;
import com.endertech.minecraft.mods.adpother.pollution.Spread;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.ModConfigSpec;

public class GasEntity
extends AbstractCarrier {
    public static final float FULL_RENDER_SCALE = 0.99f;
    public static ModConfigSpec.ConfigValue<Integer> maxGasEntitiesInChunk;
    static final long maxExistence;
    protected final GameTime stuckUpdateInterval = GameTime.seconds((int)3);
    protected static final EntityDataAccessor<Boolean> STUCK;
    protected float renderScaleXZ = 0.0f;

    public GasEntity(EntityType<?> type, Level world) {
        super(type, world);
    }

    public GasEntity(Level world, BlockPos pos, BlockState carriedState) {
        super((EntityType)AdPother.getInstance().entities.gas.get(), world, pos, carriedState);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(STUCK, (Object)false);
    }

    public boolean isStuck() {
        return (Boolean)this.getEntityData().get(STUCK);
    }

    public void setStuck(boolean value) {
        this.getEntityData().set(STUCK, (Object)value);
    }

    public boolean ignoreExplosion(Explosion explosion) {
        return true;
    }

    public boolean fasterThan(GasEntity otherGas) {
        float otherGasVelocity;
        float thisGasVelocity = this.getPollutant().map(p -> Float.valueOf(p.getMotionVelocityIn(BiomeId.from((LevelAccessor)this.level(), (BlockPos)this.blockPosition())))).orElse(Float.valueOf(0.0f)).floatValue();
        return thisGasVelocity > (otherGasVelocity = otherGas.getPollutant().map(p -> Float.valueOf(p.getMotionVelocityIn(BiomeId.from((LevelAccessor)otherGas.level(), (BlockPos)otherGas.blockPosition())))).orElse(Float.valueOf(0.0f)).floatValue());
    }

    public void baseTick() {
        boolean alignedToBlock;
        GasEntity otherGas;
        Object nextBlock;
        BlockState newState;
        Level pos;
        ServerLevel serverLevel;
        Level level;
        if (!this.isAlive()) {
            return;
        }
        if (this.isServerSide() && this.isStuck() && !this.stuckUpdateInterval.pastIn(this.level())) {
            return;
        }
        if (this.isClientSide()) {
            this.updateRenderSizeXZ();
        }
        if (this.isClientSide() && this.isStuck()) {
            return;
        }
        Level level2 = this.level();
        if (level2 instanceof ServerLevel) {
            ServerLevel serverLevel2 = (ServerLevel)level2;
            serverLevel2.resetEmptyTime();
            if (!serverLevel2.isPositionEntityTicking(this.blockPosition())) {
                return;
            }
        }
        BlockState carriedState = this.getCarriedBlockState().orElse(null);
        Pollutant pollutant = this.getPollutant().orElse(null);
        if (carriedState == null || pollutant == null || pollutant == Blocks.AIR || pollutant.getCarriedPollutionAmount(carriedState) <= 0 || this.level().isOutsideBuildHeight(this.blockPosition())) {
            if (this.isServerSide()) {
                this.discard();
            }
            return;
        }
        if (this.isStuck() && (level = this.level()) instanceof ServerLevel) {
            serverLevel = (ServerLevel)level;
            pos = this.blockPosition();
            if ((long)this.tickCount > maxExistence && !GameWorld.SmokeContainers.isChimney((LevelReader)serverLevel, (BlockPos)pos) || !serverLevel.getFluidState((BlockPos)pos).isEmpty()) {
                this.dropAsItem(serverLevel, 0.0f);
                return;
            }
        }
        if ((pos = this.level()) instanceof ServerLevel && (newState = pollutant.tryAffectBlockAt(serverLevel = (ServerLevel)pos, (BlockPos)(pos = GasEntity.getCenterPosition((Entity)this).toBlockPos()), Optional.empty(), AbstractPollutionImpacts.ImpactType.CONTACT, carriedState)) != carriedState) {
            this.setCarriedBlockState(Optional.of(newState));
            return;
        }
        Optional<Direction> motionFacing = pollutant.getMotionFacing((LevelAccessor)this.level(), this.blockPosition());
        double motionY = 0.0;
        BlockPos pos2 = this.blockPosition();
        Optional airflow = GameWorld.SmokeContainers.getPumpedChimneyAirflow((LevelReader)this.level(), (BlockPos)pos2);
        if (motionFacing.isPresent() || airflow.isPresent()) {
            float velocity = pollutant.getMotionVelocityIn(BiomeId.from((LevelAccessor)this.level(), (BlockPos)pos2));
            if (motionFacing.filter(arg_0 -> Direction.DOWN.equals(arg_0)).isPresent()) {
                velocity = -velocity;
            }
            if (airflow.isPresent()) {
                velocity = FloatBounds.between((Float)((Float)airflow.get()), (Float)Float.valueOf(1.0f)).enclose(Float.valueOf(Math.abs(velocity + ((Float)airflow.get()).floatValue()))).floatValue();
            }
            motionY = velocity;
        }
        this.setDeltaMovement(0.0, motionY, 0.0);
        boolean canPassThrough = false;
        double motionY2 = this.getDeltaMovement().y;
        if (motionY2 != 0.0) {
            AABB nextBB = this.getBB(this.getNextPosition());
            BlockPos currentBlock = this.blockPosition();
            if (currentBlock.equals(nextBlock = BlockPos.containing((double)this.getX(), (double)(motionY2 < 0.0 ? nextBB.minY : nextBB.maxY), (double)this.getZ()))) {
                canPassThrough = true;
            } else {
                Optional airflow2;
                Direction facing;
                Direction direction = facing = motionY2 < 0.0 ? Direction.DOWN : Direction.UP;
                if (pollutant.canPassThrough((LevelReader)this.level(), currentBlock, facing, facing) && pollutant.canPassThrough((LevelReader)this.level(), (BlockPos)nextBlock, facing.getOpposite(), facing.getOpposite()) && ((airflow2 = GameWorld.SmokeContainers.getPumpedChimneyAirflow((LevelReader)this.level(), (BlockPos)nextBlock)).isEmpty() || CommonMath.sameSign((double)((Float)airflow2.get()).floatValue(), (double)this.getDeltaMovement().y()))) {
                    canPassThrough = true;
                }
            }
        }
        boolean entityCollided = false;
        if (canPassThrough) {
            this.setStuck(false);
            boolean blockSize = true;
            double motionSign = Math.signum(this.getDeltaMovement().y);
            nextBlock = this.getCollidedWithIfMove(GasEntity.class, GasEntity.getMotion((Entity)this), Entity::isAlive).iterator();
            if (nextBlock.hasNext()) {
                otherGas = (GasEntity)((Object)nextBlock.next());
                if (this.isServerSide() && this.spreadTo(otherGas, 0) && this.spend()) {
                    return;
                }
                if (this.isServerSide() && !this.carriesSameBlock(otherGas.getPollutant()) && this.fasterThan(otherGas)) {
                    Optional otherState = otherGas.getCarriedBlockState();
                    otherGas.setCarriedBlockState(this.getCarriedBlockState());
                    this.setCarriedBlockState(otherState);
                    return;
                }
                double alignedY = otherGas.getY() - motionSign * 1.0;
                this.yo = this.getY();
                this.setPos(this.getX(), alignedY, this.getZ());
                canPassThrough = false;
                entityCollided = true;
                this.setOnGround(true);
            }
        }
        if (canPassThrough) {
            this.setOnGround(false);
            this.move();
            return;
        }
        this.setOnGround(true);
        long alignedY = Math.round(this.getY());
        if (!entityCollided) {
            this.setPos(this.getX(), alignedY, this.getZ());
        }
        boolean bl = alignedToBlock = this.getY() == (double)alignedY;
        if (alignedToBlock) {
            this.setStuck(true);
        }
        if (alignedToBlock && (otherGas = this.level()) instanceof ServerLevel) {
            List pumps;
            int count;
            ServerLevel serverLevel3 = (ServerLevel)otherGas;
            if (GameWorld.SmokeContainers.isVent((LevelReader)serverLevel3, (BlockPos)this.blockPosition()) && (count = GameWorld.SmokeContainers.pumpPollutionThrough((List)(pumps = GameWorld.SmokeContainers.getClosestActiveExhaustPumps((LevelAccessor)serverLevel3, (BlockPos)this.blockPosition())), (LevelAccessor)serverLevel3, (IPollutant)pollutant, (int)this.getPollutionAmount())) > 0) {
                while (count > 0 && this.spend()) {
                    --count;
                }
                return;
            }
            Spread spread = pollutant.createSpread(serverLevel3, this.blockPosition(), carriedState).overLedge().to(this.blockPosition(), Integer.MIN_VALUE).around(Integer.MIN_VALUE);
            if (spread.applyTarget()) {
                this.setCarriedBlockState(Optional.of(spread.getSourceState()));
            }
        }
    }

    protected boolean dropAsItem(ServerLevel level, float offsetY) {
        ItemStack stack;
        Pollutant pollutant = this.getPollutant().orElse(null);
        if (pollutant != null && this.spawnAtLocation(level, stack = new ItemStack((ItemLike)pollutant, this.getPollutionAmount()), offsetY) != null) {
            this.discard();
            return true;
        }
        return false;
    }

    public float getRenderOffset(Direction.Axis axis) {
        float offset = (1.0f - this.getRenderScale(axis)) / 2.0f;
        return switch (axis) {
            default -> throw new MatchException(null, null);
            case Direction.Axis.Y -> offset;
            case Direction.Axis.X, Direction.Axis.Z -> offset - 0.5f;
        };
    }

    public float getRenderScale(Direction.Axis axis) {
        return switch (axis) {
            default -> throw new MatchException(null, null);
            case Direction.Axis.Y -> 0.99f;
            case Direction.Axis.X, Direction.Axis.Z -> this.renderScaleXZ;
        };
    }

    protected int getChimneyWallThickness(BlockGetter level, BlockPos pos) {
        BlockState state = level.getBlockState(pos);
        VoxelShape chimneyShape = state.getCollisionShape(level, pos);
        for (int thickness = 3; thickness <= 6; ++thickness) {
            VoxelShape holeShape = Block.box((double)thickness, (double)0.0, (double)thickness, (double)(16 - thickness), (double)16.0, (double)(16 - thickness));
            if (!Shapes.joinUnoptimized((VoxelShape)chimneyShape, (VoxelShape)holeShape, (BooleanOp)BooleanOp.AND).isEmpty()) continue;
            return thickness;
        }
        return 7;
    }

    public void updateRenderSizeXZ() {
        float offsetY = this.getRenderOffset(Direction.Axis.Y);
        float size = 0.99f;
        for (double y : new double[]{this.getBoundingBox().minY + (double)offsetY, this.getBoundingBox().maxY - (double)offsetY}) {
            BlockPos pos = BlockPos.containing((double)this.getX(), (double)y, (double)this.getZ());
            if (!GameWorld.SmokeContainers.isChimney((LevelReader)this.level(), (BlockPos)pos)) continue;
            int thickness = this.getChimneyWallThickness((BlockGetter)this.level(), pos);
            size = Math.min(size, 0.99f - (float)(2 * thickness) / 16.0f);
        }
        this.renderScaleXZ = size;
    }

    static {
        maxExistence = GameTime.inServerTicks((CommonTime.Interval)CommonTime.Interval.minutes((double)5.0));
        STUCK = SynchedEntityData.defineId(GasEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    }
}

