/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.init;

import com.endertech.minecraft.forge.blocks.ForgeBlock;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.core.AbstractForgeMod;
import com.endertech.minecraft.forge.items.EquipmentItem;
import com.endertech.minecraft.forge.items.ForgeBucketItem;
import com.endertech.minecraft.forge.items.ForgeItem;
import com.endertech.minecraft.forge.items.GlassMeter;
import com.endertech.minecraft.forge.units.ItemsInit;
import com.endertech.minecraft.forge.units.UnitId;
import com.endertech.minecraft.mods.adpother.AdPother;
import com.endertech.minecraft.mods.adpother.blocks.AbstractGas;
import com.endertech.minecraft.mods.adpother.blocks.Dust;
import com.endertech.minecraft.mods.adpother.blocks.FilterFrame;
import com.endertech.minecraft.mods.adpother.init.Materials;
import com.endertech.minecraft.mods.adpother.items.Aerometer;
import com.endertech.minecraft.mods.adpother.items.GasBlockItem;
import com.endertech.minecraft.mods.adpother.items.Respirator;
import com.endertech.minecraft.mods.adpother.items.VacuumBag;
import com.endertech.minecraft.mods.adpother.items.VacuumTube;
import net.minecraft.ChatFormatting;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.equipment.EquipmentAssets;
import net.minecraft.world.item.equipment.Equippable;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.common.util.Lazy;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.RegisterEvent;

public class Items
extends ItemsInit {
    public final DeferredHolder<Item, Aerometer> aerometer = this.register("aerometer", key -> new Aerometer(this.createConfig(key.identifier().getPath()), ((GlassMeter.Properties)((GlassMeter.Properties)GlassMeter.Properties.of((ResourceKey)key).durability(4)).equippable(EquipmentSlot.OFFHAND, SoundEvents.GLASS_HIT)).nameColor(ChatFormatting.GREEN)));
    public final DeferredHolder<Item, ForgeBucketItem> pollutedWaterBucket;

    public Items(AbstractForgeMod mod) {
        super(mod);
        UnitConfig bagConfig = this.createConfig("vacuum_bag");
        UnitConfig tubeConfig = this.createConfig("vacuum_tube");
        UnitConfig respiratorConfig = this.createConfig("respirator");
        for (Materials material : Materials.values()) {
            material.vacuumBag = this.register(material.getName() + "_vacuum_bag", key -> new VacuumBag(bagConfig, (VacuumBag.Properties)((VacuumBag.Properties)((VacuumBag.Properties)VacuumBag.Properties.of((ResourceKey<Item>)key).capacity(material.capacity).durability(64)).repairMaterial(UnitId.from((String)"#c:leather"))).equippable(Equippable.builder((EquipmentSlot)EquipmentSlot.CHEST).setEquipSound(SoundEvents.ARMOR_EQUIP_LEATHER).setAsset(EquipmentAssets.ARMADILLO_SCUTE).build())));
            material.vacuumTube = this.register(material.getName() + "_vacuum_tube", key -> new VacuumTube(tubeConfig, (VacuumTube.Properties)((VacuumTube.Properties)VacuumTube.Properties.of((ResourceKey<Item>)key).speed(material.speed).durability(material.durability)).repairMaterial(UnitId.from((String)("#" + String.valueOf(material.crafting.location()))))));
            material.respirator = this.register(material.getName() + "_respirator", key -> new Respirator(respiratorConfig, ((EquipmentItem.Properties)((EquipmentItem.Properties)EquipmentItem.Properties.of((ResourceKey)key).durability(material.durability)).repairMaterial(UnitId.from((String)"#c:leather"))).equippable(EquipmentSlot.HEAD, SoundEvents.PLAYER_BREATH)));
            material.filterFrameItem = this.register(material.filterFrame, (key, block) -> new FilterFrame.BlockItem((ForgeBlock)block, (ForgeItem.Properties<?>)ForgeItem.Properties.of((ResourceKey)key)));
        }
        this.pollutedWaterBucket = this.register("polluted_water_bucket", key -> new ForgeBucketItem(key, () -> (Fluid)AdPother.getInstance().fluids.pollutedWaterStill.get()));
    }

    protected void onRegistration(RegisterEvent event) {
        AdPother.getInstance().pollutants.mapAll().forEach((name, pollutant) -> {
            Object patt0$temp = pollutant.get();
            if (patt0$temp instanceof AbstractGas) {
                AbstractGas gas = (AbstractGas)((Object)((Object)patt0$temp));
                Item.Properties props = new Item.Properties().setId(this.resourceKey((String)name)).useBlockDescriptionPrefix();
                if (!(gas instanceof Dust)) {
                    props.fireResistant();
                }
                Lazy item = this.addUnit((String)name, () -> new GasBlockItem(gas, props));
                event.register(this.registryKey, helper -> helper.register(this.getMod().getNamespace().identifier(name), (Object)((Item)item.get())));
            }
        });
    }
}

