/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.pollution;

import com.endertech.common.IntBounds;
import com.endertech.minecraft.forge.configs.MultiConfigProperty;
import com.endertech.minecraft.forge.configs.Parsers;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.units.UnitId;
import com.endertech.minecraft.mods.adpother.AdPother;
import java.util.Optional;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import org.jetbrains.annotations.Nullable;

public class DustLayer {
    public static final IntegerProperty LAYERS = BlockStateProperties.LAYERS;
    public static final DustLayer DEFAULT = new DustLayer(UnitId.from((String)"supplementaries:ash"), IntBounds.between((Integer)1, (Integer)8));
    public final UnitId blockId;
    public final IntBounds layerBounds;
    @Nullable
    private Optional<BlockState> blockState;

    public DustLayer(UnitId blockId, IntBounds layerBounds) {
        this.blockId = blockId;
        this.layerBounds = layerBounds;
    }

    public Optional<BlockState> getBlockState() {
        if (this.blockState == null) {
            this.blockState = Optional.ofNullable(this.blockId.getFirstMatchedState());
            if (this.blockState.isPresent() && !this.blockState.get().hasProperty((net.minecraft.world.level.block.state.properties.Property)LAYERS) && (this.layerBounds.length() > 0 || this.layerBounds.getMax() > 0)) {
                AdPother.getInstance().getLogger().error("DustLayer with blockId=" + String.valueOf(this.blockId) + "doesn't represent a block with layers");
            }
        }
        return this.blockState;
    }

    public boolean isSameBlock(BlockState state) {
        return this.getBlockState().filter(s -> s.is(state.getBlock())).isPresent();
    }

    public Optional<BlockState> asLayeredBlock(int layers) {
        if (this.getBlockState().isPresent()) {
            BlockState state = this.getBlockState().get();
            if (state.hasProperty((net.minecraft.world.level.block.state.properties.Property)LAYERS)) {
                state = (BlockState)state.setValue((net.minecraft.world.level.block.state.properties.Property)LAYERS, (Comparable)this.layerBounds.enclose(Integer.valueOf(layers)));
            }
            return Optional.of(state);
        }
        return Optional.empty();
    }

    public BlockState withAddedLayer(BlockState state) {
        if (state.hasProperty((net.minecraft.world.level.block.state.properties.Property)LAYERS)) {
            int layers = (Integer)state.getValue((net.minecraft.world.level.block.state.properties.Property)LAYERS) + 1;
            return (BlockState)state.setValue((net.minecraft.world.level.block.state.properties.Property)LAYERS, (Comparable)this.layerBounds.enclose(Integer.valueOf(layers)));
        }
        return state;
    }

    public String toString() {
        return this.blockId.toString() + ", " + this.layerBounds.getMin() + "-" + this.layerBounds.getMax();
    }

    public static class Property<K>
    extends MultiConfigProperty.BaseProperty<K, DustLayer> {
        public static <K> Property<K> create(UnitConfig config, String category, String name, DustLayer defaultValue, String comment) {
            Property<K> property = new Property<K>(config, category, name, defaultValue, comment);
            property.defaultValue = property.getFrom(config, category, defaultValue);
            return property;
        }

        protected Property(UnitConfig config, String category, String name, DustLayer defaultValue, String comment) {
            super(config, category, name, (Object)defaultValue, comment);
        }

        public DustLayer getFrom(UnitConfig config, String category, DustLayer defaultValue) {
            String string = UnitConfig.getStr((UnitConfig)config, (String)category, (String)this.getName(), (String)defaultValue.toString(), (String)this.getComment());
            Parser parser = new Parser();
            try {
                return parser.parse(string);
            }
            catch (Exception e) {
                parser.logError(AdPother.getInstance(), config, "DustLayer", string, e);
                return defaultValue;
            }
        }
    }

    protected static class Parser
    extends Parsers.AbstractParser {
        protected Parser() {
        }

        public DustLayer parse(CharSequence input) throws Exception {
            UnitId id = this.getGroup("id", input).map(UnitId::from).filter(UnitId::notEmpty).orElseThrow(() -> new Exception("Invalid id"));
            int min = this.getGroup("min", input).map(Integer::valueOf).orElseThrow(() -> new Exception("Invalid min size"));
            int max = this.getGroup("max", input).map(Integer::valueOf).orElseThrow(() -> new Exception("Invalid max size"));
            return new DustLayer(id, IntBounds.between((Integer)min, (Integer)max));
        }

        protected String regex() {
            return "^" + this.grp("id", this.unit_id()) + this.delim(",") + this.grp("min", this.digits()) + this.delim("-") + this.grp("max", this.digits()) + "$";
        }
    }
}

