/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.pollution;

import com.endertech.common.CommonMath;
import com.endertech.common.CommonTime;
import com.endertech.minecraft.forge.entities.ForgeEntity;
import com.endertech.minecraft.forge.world.GameWorld;
import com.endertech.minecraft.mods.adpother.AdPother;
import com.endertech.minecraft.mods.adpother.blocks.AbstractGas;
import com.endertech.minecraft.mods.adpother.chains.GasChain;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.ModConfigSpec;

public class GasExplosion {
    public static ModConfigSpec.ConfigValue<Boolean> ignitionSources;
    public static ModConfigSpec.ConfigValue<Boolean> enclosedEmitters;
    public static ModConfigSpec.ConfigValue<Boolean> setOnFire;
    public static ModConfigSpec.ConfigValue<Integer> maxChainLength;
    public static ModConfigSpec.ConfigValue<Level.ExplosionInteraction> explosionInteraction;
    public static ModConfigSpec.ConfigValue<Boolean> alwaysDestroyEmitter;
    protected LevelAccessor level;
    protected Iterable<BlockPos> positions = Collections.emptyList();
    protected Consumer<? super GasChain> action = chain -> {};

    protected GasExplosion(LevelAccessor level) {
        this.level = level;
    }

    public static GasExplosion in(LevelAccessor level) {
        return new GasExplosion(level);
    }

    public GasExplosion position(BlockPos position) {
        return this.positions(Collections.singleton(position));
    }

    public GasExplosion positions(Iterable<BlockPos> positions) {
        this.positions = positions;
        return this;
    }

    public GasExplosion action(Consumer<? super GasChain> action) {
        this.action = action;
        return this;
    }

    public boolean tryTrigger() {
        if (((Boolean)ignitionSources.get()).booleanValue()) {
            for (BlockPos pos : this.positions) {
                AbstractGas gas;
                BlockState state = this.level.getBlockState(pos);
                Block block = state.getBlock();
                if (!(block instanceof AbstractGas) || !(gas = (AbstractGas)block).canCauseExplosion(this.level, pos, state)) continue;
                GasChain chain = new GasChain(this.level, pos, gas, gas.getLowerExplosiveLimit());
                chain.build();
                if (chain.getFound().size() < gas.getLowerExplosiveLimit()) continue;
                this.action.accept(chain);
                return true;
            }
        }
        return false;
    }

    public boolean tryExplode() {
        return this.action(GasExplosion::explode).tryTrigger();
    }

    public static void explode(GasChain fuseChain) {
        LevelAccessor level = fuseChain.getLevel();
        GasChain fullChain = new GasChain(level, fuseChain.getStartPos(), fuseChain.getGas(), (Integer)maxChainLength.get());
        fullChain.build();
        int maxExplosions = (int)Math.max(1.0, CommonMath.raiseToPower((double)fullChain.length(), (double)0.3333333333333333));
        int maxExplosionSize = (int)Math.sqrt(fullChain.length());
        int step = Math.max(1, fullChain.length() / maxExplosions);
        HashMap<BlockPos, Float> explosions = new HashMap<BlockPos, Float>(maxExplosions + 1, 1.0f);
        for (int i = 0; i < fullChain.length(); i += step) {
            float explosionSize = 0.0f;
            BlockPos centerPos = (BlockPos)fullChain.getChain().get(i);
            for (BlockPos pos2 : GameWorld.Positions.getAroundHoriz((BlockPos)centerPos, (boolean)false, (BlockPos[])new BlockPos[]{centerPos.above(), centerPos.below(), centerPos})) {
                BlockState state = level.getBlockState(pos2);
                if (!((explosionSize += (float)fullChain.getGas().getCarriedPollutionAmount(state)) >= (float)maxExplosionSize)) continue;
                explosionSize = maxExplosionSize;
                break;
            }
            if (!(explosionSize > 0.0f)) continue;
            explosions.put(centerPos, Float.valueOf(explosionSize));
        }
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            fullChain.getChain().forEach(pos -> level.removeBlock(pos, false));
            explosions.forEach((pos, size) -> GameWorld.scheduleBlockExplosion((ServerLevel)serverLevel, (BlockPos)pos, (CommonTime.Interval)CommonTime.Interval.ZERO, (float)size.floatValue(), (boolean)((Boolean)setOnFire.get()), (Level.ExplosionInteraction)((Level.ExplosionInteraction)explosionInteraction.get()), (boolean)false, null));
        }
    }

    public static GasExplosion fromHeldTorch(Player player) {
        GasExplosion explosion = GasExplosion.in((LevelAccessor)player.level());
        Set<InteractionHand> hands = GasExplosion.getTorchHoldingHands(player);
        return hands.isEmpty() ? explosion : explosion.positions(GasExplosion.getIgnitablePositionsAround(player, hands));
    }

    public static List<BlockPos> getIgnitablePositionsAround(Player player, Set<InteractionHand> hands) {
        Direction face = player.getDirection();
        BlockPos eyes = ForgeEntity.getPositionEyes((Entity)player);
        BlockPos body = eyes.below();
        ArrayList positions = Lists.newArrayList((Object[])new BlockPos[]{eyes.above(), eyes.relative(face), body.relative(face)});
        for (InteractionHand hand : hands) {
            Direction facing = hand == InteractionHand.MAIN_HAND ? face.getClockWise() : face.getCounterClockWise();
            positions.add(eyes.relative(facing));
            positions.add(body.relative(facing));
        }
        positions.add(eyes);
        positions.add(body);
        return positions;
    }

    public static Set<InteractionHand> getTorchHoldingHands(Player player) {
        EnumSet<InteractionHand> hands = EnumSet.noneOf(InteractionHand.class);
        for (InteractionHand hand : InteractionHand.values()) {
            ItemStack stack = player.getItemInHand(hand);
            AdPother.getInstance().torches.get(stack).ifPresent(torch -> hands.add(hand));
        }
        return hands;
    }
}

