/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.pollution;

import com.endertech.common.CommonMath;
import com.endertech.common.IntBounds;
import com.endertech.minecraft.forge.configs.MultiConfigProperty;
import com.endertech.minecraft.forge.configs.Parsers;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.core.AbstractForgeMod;
import com.endertech.minecraft.forge.math.Percentage;
import com.endertech.minecraft.forge.world.AbstractGenerator;
import com.endertech.minecraft.forge.world.BiomeId;
import com.endertech.minecraft.forge.world.ChunkBounds;
import com.endertech.minecraft.forge.world.GameWorld;
import com.endertech.minecraft.forge.world.WorldBounds;
import com.endertech.minecraft.forge.world.WorldSearch;
import com.endertech.minecraft.mods.adpother.AdPother;
import com.endertech.minecraft.mods.adpother.blocks.AbstractGas;
import com.mojang.serialization.MapCodec;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.neoforged.neoforge.common.world.BiomeModifier;
import net.neoforged.neoforge.common.world.ModifiableBiomeInfo;

public class PregeneratedClouds {
    public static final Data NONE = new Data(IntBounds.ZERO, 0, false);

    public record Data(IntBounds size, int rarity, boolean persistence) {
        public boolean canGenerate(Random random) {
            return this.rarity > 0 && this.size.getMax() > 0 && Percentage.from((int)1, (int)this.rarity).takeChance(random);
        }

        @Override
        public String toString() {
            return this.size.getMin() + "-" + this.size.getMax() + ", " + this.rarity + ", " + this.persistence;
        }
    }

    public static class Property<K>
    extends MultiConfigProperty.BaseProperty<K, Data> {
        public static <K> Property<K> create(UnitConfig config, String category, String name, Data defaultValue, String comment) {
            Property<K> property = new Property<K>(config, category, name, defaultValue, comment);
            property.defaultValue = property.getFrom(config, category, defaultValue);
            return property;
        }

        protected Property(UnitConfig config, String category, String name, Data defaultValue, String comment) {
            super(config, category, name, (Object)defaultValue, comment);
        }

        public Data getFrom(UnitConfig config, String category, Data defaultValue) {
            String string = UnitConfig.getStr((UnitConfig)config, (String)category, (String)this.getName(), (String)defaultValue.toString(), (String)this.getComment());
            Parser parser = new Parser();
            try {
                return parser.parse(string);
            }
            catch (Exception e) {
                parser.logError(AdPother.getInstance(), config, "PregeneratedClouds.Data", string, e);
                return defaultValue;
            }
        }
    }

    public static class Parser
    extends Parsers.AbstractParser {
        public Data parse(CharSequence input) throws Exception {
            int min = this.getGroup("min", input).map(Integer::valueOf).orElseThrow(() -> new Exception("Invalid min size"));
            int max = this.getGroup("max", input).map(Integer::valueOf).orElseThrow(() -> new Exception("Invalid max size"));
            int rarity = this.getGroup("rarity", input).map(Integer::valueOf).orElseThrow(() -> new Exception("Invalid rarity"));
            boolean persistence = this.getGroup("persistence", input).map(Boolean::valueOf).orElseThrow(() -> new Exception("Invalid persistence"));
            return new Data(IntBounds.between((Integer)min, (Integer)max), rarity, persistence);
        }

        protected String regex() {
            return "^" + this.grp("min", this.digits()) + this.delim("-") + this.grp("max", this.digits()) + this.delim(",") + this.grp("rarity", this.digits()) + this.delim(",") + this.grp("persistence", this.bool()) + "$";
        }
    }

    public static class Generator
    extends AbstractGenerator {
        public Generator(AbstractForgeMod mod) {
            super(mod);
        }

        public boolean generateAt(WorldGenLevel level, ChunkPos chunkPos, Random random) {
            List gases = AdPother.getInstance().pollutants.streamAll().filter(AbstractGas.class::isInstance).map(AbstractGas.class::cast).filter(gas -> gas.inAllowableDimension(level.getLevel())).collect(Collectors.toList());
            boolean result = false;
            Collections.shuffle(gases, random);
            for (AbstractGas gas2 : gases) {
                int amount;
                int altitude;
                int y;
                BiomeId biome;
                Data data = gas2.getPregeneratedCloudsData(biome = BiomeId.from((LevelAccessor)level, (BlockPos)chunkPos.getMiddleBlockPosition(y = level.getHeight(Heightmap.Types.WORLD_SURFACE_WG, chunkPos.getMiddleBlockX(), chunkPos.getMiddleBlockZ()))));
                if (!data.canGenerate(random) || Generator.generateCloud(level, chunkPos, altitude = gas2.getConcentrationAltitudeIn(biome), gas2, amount = data.size.randomBetween(random).intValue(), random) <= 0) continue;
                result = true;
            }
            return result;
        }

        public static boolean fillWithGas(WorldGenLevel level, BlockPos pos, AbstractGas gas) {
            return level.isEmptyBlock(pos) && level.setBlock(pos, gas.defaultBlockState(), 18);
        }

        public static int generateCloud(WorldGenLevel level, ChunkPos chunkPos, int altitude, AbstractGas gas, int maxBlocks, Random random) {
            if (maxBlocks <= 0) {
                return 0;
            }
            int radius = 2;
            ChunkBounds chunkBounds = ChunkBounds.from((LevelHeightAccessor)level, (ChunkPos)chunkPos);
            WorldBounds chunksAround = WorldBounds.chunksAround((LevelHeightAccessor)level, (ChunkPos)chunkPos);
            BlockPos startPos = chunkBounds.randomPos(random).atY(altitude);
            Segment startSegment = Segment.at(startPos, 2);
            return CloudChain.generate((LevelAccessor)level, chunksAround, startSegment, gas, maxBlocks, random);
        }

        public static int generateSpots(WorldGenLevel level, ChunkPos chunkPos, int altitude, AbstractGas gas, int maxBlocks, Random random) {
            int count;
            int lastgen;
            ChunkBounds chunkBounds = ChunkBounds.from((LevelHeightAccessor)level, (ChunkPos)chunkPos);
            for (count = 0; count < maxBlocks; count += lastgen) {
                BlockPos startPos = chunkBounds.randomPos(random).atY(altitude);
                int remains = maxBlocks - count;
                int generate = (int)CommonMath.Random.between((float)1.0f, (float)Mth.sqrt((float)maxBlocks));
                if (generate > remains) {
                    generate = remains;
                }
                lastgen = gas.generateAt(level, startPos, generate, 16);
                if (lastgen != 0) continue;
                break;
            }
            return count;
        }

        @Deprecated
        public static int generateMultilayeredCloud(WorldGenLevel level, BlockPos startPos, int maxRadius, AbstractGas gas, int maxBlocks, Random random) {
            int count = 0;
            if (count >= maxBlocks) {
                return count;
            }
            int capacity = gas.getPollutionCapacity();
            for (int layer = 0; layer < capacity; ++layer) {
                int[] yCoords;
                int[] nArray;
                int sign;
                int n = sign = layer > 0 ? CommonMath.Random.sign((Random)random) : 0;
                if (sign != 0) {
                    int[] nArray2 = new int[2];
                    nArray2[0] = startPos.getY() - sign * layer;
                    nArray = nArray2;
                    nArray2[1] = startPos.getY() + sign * layer;
                } else {
                    int[] nArray3 = new int[1];
                    nArray = nArray3;
                    nArray3[0] = startPos.getY();
                }
                for (int y : yCoords = nArray) {
                    if (level.isOutsideBuildHeight(y)) continue;
                    for (int density = 0; density < capacity; ++density) {
                        int layerMaxRadius = maxRadius - layer * 2 - density;
                        for (int radius = 0; radius <= layerMaxRadius; ++radius) {
                            List positions = GameWorld.Positions.getAroundHoriz((BlockPos)startPos.atY(y), (int)radius, (radius < layerMaxRadius || radius == 1 ? 1 : 0) != 0);
                            Collections.shuffle(positions, random);
                            for (BlockPos pos : positions) {
                                if ((count += gas.pump((LevelAccessor)level, pos, 1)) < maxBlocks) continue;
                                return count;
                            }
                        }
                    }
                }
            }
            return count;
        }

        public void modify(Holder<Biome> biome, BiomeModifier.Phase phase, ModifiableBiomeInfo.BiomeInfo.Builder builder) {
            if (phase == BiomeModifier.Phase.ADD) {
                builder.getGenerationSettings().addFeature(GenerationStep.Decoration.TOP_LAYER_MODIFICATION, this.placedFeature);
            }
        }

        public MapCodec<? extends BiomeModifier> codec() {
            return (MapCodec)AdPother.getInstance().codecs.cloud_generator.get();
        }
    }

    public static class CloudChain
    extends WorldSearch.BlockChain {
        protected final WorldBounds areaBounds;
        protected final Segment startSegment;
        protected final AbstractGas gas;
        protected final Random random;
        protected final int maxBlocks;
        protected int count = 0;

        public static int generate(LevelAccessor level, WorldBounds areaBounds, Segment startSegment, AbstractGas gas, int maxBlocks, Random random) {
            CloudChain chain = new CloudChain(level, areaBounds, startSegment, gas, maxBlocks, random);
            chain.build();
            return chain.getCount();
        }

        protected CloudChain(LevelAccessor level, WorldBounds areaBounds, Segment startSegment, AbstractGas gas, int maxBlocks, Random random) {
            super(level, startSegment.center, areaBounds.getX().length() * areaBounds.getZ().length() / startSegment.capacity());
            this.areaBounds = areaBounds;
            this.startSegment = startSegment;
            this.gas = gas;
            this.random = random;
            this.maxBlocks = maxBlocks;
        }

        protected Collection<Direction> getDirections() {
            return GameWorld.Directions.of().horizontals().shuffle(this.random).toList();
        }

        protected boolean isValidPath(BlockPos pos) {
            return this.startSegment.relative(pos).within(this.areaBounds);
        }

        protected boolean isValidBlock(BlockPos pos) {
            return this.startSegment.relative(pos).within(this.areaBounds);
        }

        protected boolean onValidFound(BlockPos pos) {
            int remains = this.maxBlocks - this.count;
            if (remains <= 0) {
                return false;
            }
            Segment segment = this.startSegment.relative(pos);
            if (remains < segment.capacity()) {
                BlockPos start = this.lastUsedDirection != null ? segment.center.relative(this.lastUsedDirection.getOpposite(), segment.radius) : segment.center;
                this.count += CloudChain.generate(this.getLevel(), segment.bounds, Segment.at(start, 0), this.gas, remains, this.random);
                return false;
            }
            segment.bounds.forEach(mutablePos -> this.fillWithGas(mutablePos.immutable()));
            return true;
        }

        protected boolean fillWithGas(BlockPos pos) {
            WorldGenLevel level;
            LevelAccessor levelAccessor = this.getLevel();
            if (levelAccessor instanceof WorldGenLevel && Generator.fillWithGas(level = (WorldGenLevel)levelAccessor, pos, this.gas)) {
                ++this.count;
                return true;
            }
            return false;
        }

        public int getCount() {
            return this.count;
        }

        public void build() {
            this.count = 0;
            super.build();
        }
    }

    public static final class Segment {
        public final WorldBounds bounds;
        public final BlockPos center;
        public final int radius;

        public static Segment at(BlockPos center, int radius) {
            return new Segment(center, radius);
        }

        public static int minRadiusFor(int capacity) {
            return capacity < 9 ? 0 : Mth.ceil((float)((Mth.sqrt((float)capacity) - 1.0f) / 2.0f));
        }

        public Segment(BlockPos center, int radius) {
            this.center = center;
            this.radius = radius;
            this.bounds = WorldBounds.horizPlane((BlockPos)center, (int)radius);
        }

        public int capacity() {
            return this.sidelength() * this.sidelength();
        }

        public Segment relative(BlockPos pos) {
            BlockPos offset = pos.subtract((Vec3i)this.center).multiply(this.sidelength());
            return new Segment(this.center.offset((Vec3i)offset), this.radius);
        }

        public int sidelength() {
            return this.radius * 2 + 1;
        }

        public boolean within(WorldBounds bounds) {
            return this.bounds.within(bounds);
        }
    }
}

