/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.renderers;

import com.endertech.minecraft.mods.adpother.blocks.FilterFrame;
import com.endertech.minecraft.mods.adpother.renderers.FilterFrameRenderState;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.state.BlockEntityRenderState;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.client.renderer.item.ItemModelResolver;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class FilterFrameRenderer
implements BlockEntityRenderer<FilterFrame.BlockTile, FilterFrameRenderState> {
    static final ItemStack PAPER_REPLACER = new ItemStack((ItemLike)Blocks.CLAY);
    protected final ItemModelResolver itemModelResolver;

    public FilterFrameRenderer(BlockEntityRendererProvider.Context context) {
        this.itemModelResolver = context.itemModelResolver();
    }

    public FilterFrameRenderState createRenderState() {
        return new FilterFrameRenderState();
    }

    public void extractRenderState(FilterFrame.BlockTile tile, FilterFrameRenderState renderState, float partialTick, Vec3 cameraPosition, @Nullable ModelFeatureRenderer.CrumblingOverlay breakProgress) {
        super.extractRenderState((BlockEntity)tile, (BlockEntityRenderState)renderState, partialTick, cameraPosition, breakProgress);
        ItemStack material = tile.getRenderMaterial();
        if (material.getItem() == Items.PAPER) {
            material = PAPER_REPLACER;
        }
        this.itemModelResolver.updateForTopItem(renderState.materialRenderState, material, ItemDisplayContext.FIXED, tile.getLevel(), null, 0);
    }

    public void submit(FilterFrameRenderState renderState, PoseStack poseStack, SubmitNodeCollector nodeCollector, CameraRenderState cameraRenderState) {
        if (renderState.materialRenderState.isEmpty()) {
            return;
        }
        float offset = 0.5f;
        float scale = 1.2f;
        poseStack.pushPose();
        poseStack.translate(0.5f, 0.5f, 0.5f);
        poseStack.scale(1.2f, 1.2f, 1.2f);
        renderState.materialRenderState.submit(poseStack, nodeCollector, renderState.lightCoords, OverlayTexture.NO_OVERLAY, 0);
        poseStack.popPose();
    }
}

