/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.blocks;

import com.endertech.common.CommonCollect;
import com.endertech.common.CommonTime;
import com.endertech.common.FloatBounds;
import com.endertech.common.IntBounds;
import com.endertech.minecraft.forge.blocks.ForgeBlock;
import com.endertech.minecraft.forge.blocks.ISmokeContainer;
import com.endertech.minecraft.forge.blocks.ITiledBlock;
import com.endertech.minecraft.forge.blocks.IWaterLoggable;
import com.endertech.minecraft.forge.configs.ColorARGB;
import com.endertech.minecraft.forge.configs.IForgeEnum;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.data.ForgeEnergy;
import com.endertech.minecraft.forge.data.Names;
import com.endertech.minecraft.forge.math.GameBounds;
import com.endertech.minecraft.forge.math.GameTime;
import com.endertech.minecraft.forge.math.Percentage;
import com.endertech.minecraft.forge.network.ForgeNetMsg;
import com.endertech.minecraft.forge.tiles.ForgeTileWithInventory;
import com.endertech.minecraft.forge.tiles.TileInventory;
import com.endertech.minecraft.forge.units.ITickableUnit;
import com.endertech.minecraft.forge.world.GameWorld;
import com.endertech.minecraft.mods.adpother.AdPother;
import com.endertech.minecraft.mods.adpother.blocks.Pollutant;
import com.endertech.minecraft.mods.adpother.blocks.PollutedWater;
import com.endertech.minecraft.mods.adpother.chains.WaterChain;
import com.endertech.minecraft.mods.adpother.entities.PurifiedAir;
import com.endertech.minecraft.mods.adpother.pollution.IFilterFrame;
import com.endertech.minecraft.mods.adpother.pollution.IPurifier;
import com.endertech.minecraft.mods.adpother.pollution.IStorage;
import com.endertech.minecraft.mods.adpother.pollution.IStorageItem;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.Hopper;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.common.util.Lazy;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.wrapper.CombinedInvWrapper;
import net.neoforged.neoforge.items.wrapper.RangedWrapper;
import net.neoforged.neoforge.network.IContainerFactory;
import org.jetbrains.annotations.NotNull;

public class FilterFrame
extends ForgeBlock
implements ITiledBlock<BlockTile>,
IFilterFrame<BlockTile>,
ISmokeContainer,
IWaterLoggable {
    public static final EnumProperty<Condition> SATURATION = EnumProperty.create((String)"condition", Condition.class);
    public static final float WALL_THICKNESS = 0.125f;
    protected static final VoxelShape HOLE = FilterFrame.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    protected static final VoxelShape FILTER = FilterFrame.box((double)4.0, (double)4.0, (double)4.0, (double)12.0, (double)12.0, (double)12.0);
    protected static final VoxelShape SHAPE_EMPTY = Shapes.join((VoxelShape)Shapes.block(), (VoxelShape)HOLE, (BooleanOp)BooleanOp.ONLY_FIRST);
    protected static final VoxelShape SHAPE_FILLED = Shapes.or((VoxelShape)SHAPE_EMPTY, (VoxelShape)FILTER);
    protected final int slotLimit;
    protected final ForgeEnergy.StorageProps energyProps;
    protected final AirPurifier airPurifier;
    protected final WaterPurifier waterPurifier;

    public FilterFrame(UnitConfig config, Properties<?> props) {
        super(config, props);
        String category = props.name;
        this.slotLimit = props.slotLimit;
        this.energyProps = ForgeEnergy.StorageProps.create((UnitConfig)config, (String)category, (boolean)false, (int)(props.slotLimit * 100), (int)50);
        this.airPurifier = new AirPurifier(config, category, props.airPurifierEffectiveRadius, props.airPurifierMaxRadius);
        this.waterPurifier = new WaterPurifier(config, category, props.waterPurifierMaxRadius, props.waterPurifierEfficiency);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(SATURATION, (Comparable)((Object)Condition.CLEAN))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public Class<BlockTile> getTileClass() {
        return BlockTile.class;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{SATURATION, WATERLOGGED});
    }

    public FluidState getFluidState(BlockState state) {
        return IWaterLoggable.getFluidState((BlockState)state, (boolean)true);
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return IWaterLoggable.getStateForPlacement((BlockPlaceContext)context, (BlockState)this.defaultBlockState());
    }

    public BlockState updateShape(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        return IWaterLoggable.updateFluidPostPlacement((LevelAccessor)worldIn, (BlockPos)currentPos, (BlockState)stateIn);
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return this.hasFilterMaterialInstalled(world, pos) ? SHAPE_FILLED : SHAPE_EMPTY;
    }

    public VoxelShape getInteractionShape(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return Shapes.block();
    }

    public boolean isLadder(BlockState state, LevelReader world, BlockPos pos, LivingEntity entity) {
        return !this.hasFilterMaterialInstalled((BlockGetter)world, pos);
    }

    public boolean hasFilterMaterialInstalled(BlockGetter world, BlockPos pos) {
        return this.getTile(world, pos).map(tile -> !tile.getFilterMaterial().isEmpty()).orElse(false);
    }

    public BlockTile createTile(BlockPos pos, BlockState state) {
        return new BlockTile(pos, state);
    }

    @Override
    public int fill(BlockTile storage, Pollutant<?> pollutant, int amount) {
        Level level;
        if (amount <= 0) {
            return 0;
        }
        if (!storage.isActive()) {
            return 0;
        }
        IStorage.Content content = this.getContent(storage);
        ItemStack filterMaterial = storage.getFilterMaterial();
        int fullnessOld = content.getFullnessWith(pollutant);
        int count = content.fillWith(pollutant, amount);
        int fullnessNew = content.getFullnessWith(pollutant);
        int materialCapacity = pollutant.getFilterMaterials().getCapacityFor(filterMaterial);
        ForgeEnergy.Storage energyStorage = storage.energyStorage;
        int materialUsed = materialCapacity != 0 ? fullnessNew / materialCapacity - fullnessOld / materialCapacity : 0;
        int energyUsed = energyStorage.getConsumption() * count;
        energyStorage.extractEnergy(energyUsed, false);
        storage.partialFullness = fullnessNew;
        TileInventory inventory = storage.getTileInventory();
        inventory.extractItem(0, materialUsed, false);
        ItemStack byproduct = pollutant.getFilterMaterials().getByproductFor(filterMaterial, materialUsed);
        inventory.insertItem(1, byproduct, false);
        this._handleChanges(content, (Object)storage);
        if (count > 0 && (level = storage.getLevel()) instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            new PollutantFilteredMsg(pollutant, storage.getBlockPos()).sendToAllObservingChunk(level2, storage.getBlockPos());
        }
        return count;
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        Optional tile = this.getTile((BlockGetter)level, pos);
        if (GameWorld.isServerSide((LevelReader)level) && tile.isPresent()) {
            ((BlockTile)((Object)tile.get())).energyStorage.set(this.energyProps);
            ((BlockTile)((Object)tile.get())).syncWithClients();
        }
    }

    public AirPurifier getAirPurifier() {
        return this.airPurifier;
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.is(newState.getBlock())) {
            this.getTile((BlockGetter)level, pos).ifPresent(tile -> {
                FilterFrame.popResource((Level)level, (BlockPos)pos, (ItemStack)tile.getFilterMaterial());
                FilterFrame.popResource((Level)level, (BlockPos)pos, (ItemStack)tile.getByproduct());
                this.updateNeighbours(level, pos, state);
            });
        }
        super.onRemove(state, level, pos, newState, isMoving);
    }

    protected void updateNeighbours(Level level, BlockPos pos, BlockState state) {
        level.updateNeighborsAt(pos, (Block)this);
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    @Override
    public IStorage.Content getContent(BlockTile tile) {
        return tile.content;
    }

    @Override
    public void onContentChanged(IStorage.Content content, BlockTile tile) {
        Level level = tile.getLevel();
        if (level != null && GameWorld.isServerSide((LevelReader)level)) {
            level.scheduleTick(tile.getBlockPos(), (Block)this, 1);
        }
    }

    protected void spawnParticles(Level level, BlockPos pos, ColorARGB color) {
        DustParticleOptions options = new DustParticleOptions(Vec3.fromRGB24((int)color.getARGB()).toVector3f(), 1.0f);
        for (Direction direction : Direction.values()) {
            BlockPos blockpos = pos.relative(direction);
            if (level.getBlockState(blockpos).isSolidRender((BlockGetter)level, blockpos)) continue;
            Function<Direction.Axis, Double> delta = axis -> direction.getAxis() == axis ? 0.5 + 0.5625 * (double)direction.getNormal().get(axis) : level.getRandom().nextDouble();
            level.addParticle((ParticleOptions)options, (double)pos.getX() + delta.apply(Direction.Axis.X), (double)pos.getY() + delta.apply(Direction.Axis.Y), (double)pos.getZ() + delta.apply(Direction.Axis.Z), 0.0, 0.0, 0.0);
        }
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        BlockTile tile = this.getTile((BlockGetter)level, pos).orElse(null);
        if (tile != null && tile.lastFillingTime != null && tile.lastFilteredPollutant != null && CommonTime.Interval.passedFrom((CommonTime.Stamp)tile.lastFillingTime).lessThan(CommonTime.Interval.seconds((double)1.0))) {
            this.spawnParticles(level, pos, tile.lastFilteredPollutant.getColor());
        }
    }

    public void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource rand) {
        BlockTile storage = this.getTile((BlockGetter)level, pos).orElse(null);
        if (storage == null) {
            return;
        }
        IStorage.Content content = this.getContent(storage);
        ItemStack filterMaterial = storage.getFilterMaterial();
        List<Pollutant<?>> targetPollutants = storage.getTargetPollutants();
        for (Pollutant<?> pollutant2 : targetPollutants) {
            ItemStack byproduct;
            int capacity = this.getInitialCapacity(storage);
            int materialCapacity = pollutant2.getFilterMaterials().getCapacityFor(filterMaterial);
            int fullness = Math.max(storage.partialFullness, content.getFullnessWith(pollutant2));
            if (materialCapacity != 0) {
                storage.partialFullness = fullness %= materialCapacity;
            }
            if (ItemStack.isSameItem((ItemStack)(byproduct = storage.getByproduct()), (ItemStack)pollutant2.getFilterMaterials().getByproductFor(filterMaterial, 1))) {
                fullness += materialCapacity * byproduct.getCount();
            } else if (!byproduct.isEmpty()) {
                fullness = capacity;
            }
            content.installFiltersFor(capacity, pollutant2);
            content.setFullnessWith(pollutant2, fullness);
        }
        AdPother.getInstance().pollutants.streamAll().forEach(pollutant -> {
            if (!targetPollutants.contains(pollutant)) {
                content.removeFiltersFor((Pollutant<?>)((Object)pollutant));
            }
        });
        storage.getTileInventory().setStackInSlot(2, CommonCollect.getRandomElementFrom(targetPollutants).map(ItemStack::new).orElse(ItemStack.EMPTY));
        this.dropByProductToBottomHopper(storage.getTileInventory());
        this.updateBlockState((Level)level, pos, state, content.getHighestFullnessPercentage());
        this.updateNeighbours((Level)level, pos, state);
        storage.renderMaterial = storage.getFilterMaterial();
        storage.isActive();
        content.changed = false;
        storage.syncWithClients();
    }

    protected boolean dropByProductToBottomHopper(TileInventory tileInventory) {
        ItemStack extractItem;
        Level world = tileInventory.getTile().getLevel();
        Hopper hopper = this.getBottomHopper(world, tileInventory.getTile().getBlockPos()).orElse(null);
        if (hopper != null && !(extractItem = tileInventory.extractItem(1, 1, true)).isEmpty()) {
            for (int j = 0; j < hopper.getContainerSize(); ++j) {
                ItemStack destStack = hopper.getItem(j);
                if (!hopper.canPlaceItem(j, extractItem) || !destStack.isEmpty() && (destStack.getCount() >= destStack.getMaxStackSize() || destStack.getCount() >= hopper.getMaxStackSize() || !ItemStack.isSameItemSameComponents((ItemStack)extractItem, (ItemStack)destStack))) continue;
                extractItem = tileInventory.extractItem(1, 1, false);
                if (destStack.isEmpty()) {
                    hopper.setItem(j, extractItem);
                } else {
                    destStack.grow(1);
                    hopper.setItem(j, destStack);
                }
                hopper.setChanged();
                return true;
            }
        }
        return false;
    }

    private boolean isChimneyOrPump(LevelReader world, BlockPos pos) {
        return GameWorld.SmokeContainers.isChimney((LevelReader)world, (BlockPos)pos) || GameWorld.SmokeContainers.isPump((LevelReader)world, (BlockPos)pos);
    }

    protected Optional<Hopper> getBottomHopper(Level world, BlockPos startPos) {
        BlockPos pos = GameWorld.Positions.getLastInLine((LevelReader)world, (BlockPos)startPos, this::isChimneyOrPump, (Direction)Direction.DOWN).below();
        BlockEntity tile = world.getBlockEntity(pos);
        return tile instanceof Hopper ? Optional.of((Hopper)tile) : Optional.empty();
    }

    protected void updateBlockState(Level world, BlockPos pos, BlockState state, Percentage fullness) {
        BlockState newState = (BlockState)this.defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)((Boolean)state.getValue((Property)WATERLOGGED)));
        if (fullness.getGrade() == Percentage.Grade.HIGH) {
            newState = (BlockState)this.defaultBlockState().setValue(SATURATION, (Comparable)((Object)Condition.DIRTY));
        }
        if (state != newState) {
            world.setBlockAndUpdate(pos, newState);
        }
    }

    public boolean isSignalSource(BlockState state) {
        return true;
    }

    public int getSignal(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        LevelReader reader;
        if (direction == Direction.UP && level instanceof LevelReader && GameWorld.SmokeContainers.isPump((LevelReader)(reader = (LevelReader)level), (BlockPos)pos.below()) && this.getTile(level, pos).map(BlockTile::isActive).orElse(false).booleanValue()) {
            return GameBounds.REDSTONE_POWER.getIntBounds().getMax();
        }
        return 0;
    }

    public int getDirectSignal(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return this.getSignal(state, level, pos, direction);
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState state, Level level, BlockPos pos) {
        BlockTile tile = this.getTile((BlockGetter)level, pos).orElse(null);
        if (tile != null && tile.isActive()) {
            Percentage percentage = this.getContent(tile).getHighestFullnessPercentage();
            float factor = percentage.toFraction();
            int signal = GameBounds.REDSTONE_POWER.getIntBounds().interpolateDown(factor);
            return Math.max(1, signal);
        }
        return 0;
    }

    @Override
    public int getInitialCapacity(BlockTile storage) {
        int capacity = 0;
        ItemStack filterMaterial = storage.getFilterMaterial();
        for (Pollutant<?> pollutant : storage.getTargetPollutants()) {
            int materialCapacity = pollutant.getFilterMaterials().getCapacityFor(filterMaterial);
            capacity = Math.max(capacity, materialCapacity * storage.getTileInventory().getSlotLimit(0));
        }
        return capacity;
    }

    public InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            this.getTile((BlockGetter)level, pos).ifPresent(arg_0 -> ((ServerPlayer)serverPlayer).openMenu(arg_0));
            return InteractionResult.CONSUME;
        }
        return InteractionResult.SUCCESS;
    }

    public ColorARGB getColor() {
        return ColorARGB.DEFAULT;
    }

    public ISmokeContainer.Type getType() {
        return ISmokeContainer.Type.CHIMNEY;
    }

    public boolean isActive(BlockGetter level, BlockPos pos) {
        LevelReader reader;
        BlockState state = level.getBlockState(pos);
        if (!(!IWaterLoggable.isWaterlogged((BlockState)state) || level instanceof LevelReader && GameWorld.SmokeContainers.isPump((LevelReader)(reader = (LevelReader)level), (BlockPos)pos.below()))) {
            return false;
        }
        return this.getTile(level, pos).map(BlockTile::isActive).orElse(false);
    }

    public static class Properties<T extends Properties<T>>
    extends ForgeBlock.Properties<T> {
        public int airPurifierEffectiveRadius = 1;
        public int airPurifierMaxRadius = 1;
        public int waterPurifierMaxRadius = 1;
        public Percentage waterPurifierEfficiency = Percentage.value((float)12.0f);
        public int slotLimit = 16;

        public static Properties<?> of(String name) {
            return new Properties<Properties>(Properties.class, name);
        }

        protected Properties(Class<T> selfClass, String name) {
            super(selfClass, name);
            this.vanillaProps.strength(1.5f, 30.0f).randomTicks().noOcclusion().isViewBlocking((state, lev, pos) -> false);
        }

        public T airPurifier(int effectiveRadius, int maxRadius) {
            this.airPurifierEffectiveRadius = effectiveRadius;
            this.airPurifierMaxRadius = maxRadius;
            return (T)((Object)((Properties)this.self));
        }

        public T waterPurifier(int maxRadius, Percentage efficiency) {
            this.waterPurifierMaxRadius = maxRadius;
            this.waterPurifierEfficiency = efficiency;
            return (T)((Object)((Properties)this.self));
        }

        public T slotLimit(int slotLimit) {
            this.slotLimit = slotLimit;
            return (T)((Object)((Properties)this.self));
        }
    }

    public static class AirPurifier
    implements IPurifier {
        public static final int MAX_RADIUS = 32;
        public final int effectiveRadius;
        public final int maximumRadius;

        public AirPurifier(UnitConfig config, String headCategory, int effectiveRadius, int maximumRadius) {
            String category = Names.dotted().join(new String[]{headCategory, "AirPurifier"});
            this.effectiveRadius = UnitConfig.getInt((UnitConfig)config, (String)category, (String)"effectiveRadius", (int)effectiveRadius, (IntBounds)IntBounds.between((Integer)0, (Integer)32), (String)"Defines the radius of the area in which the purified air created by this purifier has the maximum effect");
            this.maximumRadius = UnitConfig.getInt((UnitConfig)config, (String)category, (String)"maximumRadius", (int)maximumRadius, (IntBounds)IntBounds.between((Integer)0, (Integer)32), (String)"Defines the maximum radius of the purified air effect.\nThe effect will fade between effectiveRadius and maximumRadius");
        }

        @Override
        public BlockPos getOutputPos(LevelReader world, BlockPos filterPos) {
            while (GameWorld.SmokeContainers.isChimney((LevelReader)world, (BlockPos)(filterPos = filterPos.above()))) {
            }
            return filterPos;
        }

        @Override
        public BlockPos getPumpPos(LevelReader world, BlockPos filterPos) {
            BlockPos pumpPos = filterPos;
            while (GameWorld.SmokeContainers.isChimney((LevelReader)world, (BlockPos)(pumpPos = pumpPos.below()))) {
            }
            return pumpPos;
        }

        @Override
        public boolean hasProperInput(LevelReader world, BlockPos pumpPos) {
            return !this.isBlockedFromAllSides(world, pumpPos, GameWorld.Directions.CLOCKWISE_HORIZONTALS);
        }

        protected boolean isBlockedFromAllSides(LevelReader world, BlockPos centerPos, Direction ... sides) {
            for (Direction side : sides) {
                if (this.isSideBlocked(world, centerPos, side)) continue;
                return false;
            }
            return true;
        }

        protected boolean isSideBlocked(LevelReader world, BlockPos pos, Direction side) {
            if (world.getBlockState(pos).isFaceSturdy((BlockGetter)world, pos, side)) {
                return true;
            }
            BlockPos nextpos = pos.relative(side);
            if (world.getBlockState(nextpos).isFaceSturdy((BlockGetter)world, nextpos, side.getOpposite())) {
                return true;
            }
            float height = world.getFluidState(nextpos).getHeight((BlockGetter)world, nextpos);
            return (double)height >= 0.7;
        }

        @Override
        public boolean hasProperOutput(LevelReader world, BlockPos outputPos) {
            while (!world.isOutsideBuildHeight(outputPos)) {
                BlockState state = world.getBlockState(outputPos);
                if (state.isAir()) {
                    return true;
                }
                if (state.isFaceSturdy((BlockGetter)world, outputPos, Direction.DOWN)) {
                    return false;
                }
                if (this.isBlockedFromAllSides(world, outputPos, GameWorld.Directions.of().horizontals().up().toArray())) {
                    return false;
                }
                outputPos = outputPos.above();
            }
            return false;
        }
    }

    public static class WaterPurifier
    implements IPurifier {
        public static final CommonTime.Interval DEFAULT_UPDATE_INTERVAL = CommonTime.Interval.seconds((double)10.0);
        public static final int MAX_RADIUS = 16;
        public final int maximumRadius;
        public final Percentage efficiency;
        public CommonTime.Interval updateInterval;

        public WaterPurifier(UnitConfig config, String headCategory, int maximumRadius, Percentage efficiency) {
            this(config, headCategory, maximumRadius, efficiency, DEFAULT_UPDATE_INTERVAL);
        }

        public WaterPurifier(UnitConfig config, String headCategory, int maximumRadius, Percentage efficiency, CommonTime.Interval updateInterval) {
            String category = Names.dotted().join(new String[]{headCategory, "WaterPurifier"});
            this.maximumRadius = UnitConfig.getInt((UnitConfig)config, (String)category, (String)"maximumRadius", (int)maximumRadius, (IntBounds)IntBounds.between((Integer)0, (Integer)16), (String)"Defines the maximum cleaning radius of the purifier (in blocks).");
            this.efficiency = UnitConfig.getPercentage((UnitConfig)config, (String)category, (String)"efficiency", (Percentage)efficiency, (FloatBounds)GameBounds.PERCENTAGE.getFloatBounds(), (String)"Defines the efficiency of the purifier (in percent).\nThe lower the efficiency, the more filter material will be used up and the longer the cleaning process will take.");
            this.updateInterval = CommonTime.Interval.seconds((double)UnitConfig.getInt((UnitConfig)config, (String)category, (String)"updateInterval", (int)((int)updateInterval.inSeconds()), (IntBounds)IntBounds.between((Integer)1, (Integer)120), (String)"Defines the update interval (in seconds).\nThe smaller the interval, the higher the cleaning speed."));
        }

        @Override
        public BlockPos getOutputPos(LevelReader world, BlockPos filterPos) {
            return filterPos.above();
        }

        @Override
        public BlockPos getPumpPos(LevelReader world, BlockPos filterPos) {
            BlockPos pos = filterPos.below();
            if (GameWorld.SmokeContainers.isChimney((LevelReader)world, (BlockPos)pos)) {
                pos = pos.below();
            }
            return pos;
        }

        @Override
        public boolean hasProperInput(LevelReader world, BlockPos pumpPos) {
            return GameWorld.Positions.getAroundHoriz((BlockPos)pumpPos, (boolean)false, (BlockPos[])new BlockPos[0]).stream().anyMatch(pos -> world.getBlockState(pos).getFluidState().is(FluidTags.WATER));
        }

        @Override
        public boolean hasProperOutput(LevelReader world, BlockPos outputPos) {
            return GameWorld.isAirBlock((LevelReader)world, (BlockPos)outputPos);
        }

        public Optional<BlockPos> findPollutedWater(final LevelAccessor world, BlockPos filterPos, final List<Pollutant<?>> targetPollutants) {
            WaterChain chain = new WaterChain(this, world, this.getPumpPos((LevelReader)world, filterPos), this.maximumRadius){

                protected boolean onValidFound(BlockPos pos) {
                    return false;
                }

                protected boolean isValidBlock(BlockPos pos) {
                    return this.isWithinMaxRadius(pos) && PollutedWater.isSource((BlockGetter)world, pos) && PollutedWater.findPollutant((BlockGetter)world, pos, targetPollutants).isPresent();
                }
            };
            chain.build();
            return chain.getFound().stream().findFirst();
        }
    }

    public static enum Condition implements IForgeEnum
    {
        CLEAN,
        DIRTY;

    }

    public static class BlockTile
    extends ForgeTileWithInventory
    implements ITickableUnit {
        protected ItemStack renderMaterial = ItemStack.EMPTY;
        protected boolean active = false;
        protected boolean purifyingAir = false;
        protected boolean purifyingWater = false;
        @Nullable
        protected CommonTime.Stamp lastFillingTime = null;
        @Nullable
        protected Pollutant<?> lastFilteredPollutant = null;
        protected int partialFullness = 0;
        protected final IStorage.Content content = new IStorage.Content(0);
        protected final TileInventory inventory = new Inventory((BlockEntity)this, 3);
        protected final ContainerData dataAccess;
        protected final ForgeEnergy.Storage energyStorage = ForgeEnergy.Storage.empty();
        private final GameTime updateInterval = GameTime.ticks((long)1L);
        protected final Lazy<GameTime> airPurifierUpdateInterval = Lazy.of(GameTime::second);
        protected final Lazy<GameTime> waterPurifierUpdateInterval = Lazy.of(() -> GameTime.time((CommonTime.Interval)this.getFilter().map(filter -> filter.waterPurifier.updateInterval).orElse(WaterPurifier.DEFAULT_UPDATE_INTERVAL)));

        public BlockTile(BlockPos pos, BlockState state) {
            super((BlockEntityType)AdPother.getInstance().tiles.filterFrame.get(), pos, state);
            this.dataAccess = new ContainerData(){

                public int get(int pIndex) {
                    switch (pIndex) {
                        case 0: {
                            Pollutant pollutant;
                            int materialCapacity;
                            Block block = Block.byItem((Item)this.getTileInventory().getStackInSlot(2).getItem());
                            if (block instanceof Pollutant && (materialCapacity = (pollutant = (Pollutant)block).getFilterMaterials().getCapacityFor(this.getFilterMaterial())) > 0) {
                                int fullness = content.getFullnessWith(pollutant) % materialCapacity;
                                return (int)Percentage.from((int)fullness, (int)materialCapacity).getValue();
                            }
                            return 0;
                        }
                    }
                    return 0;
                }

                public void set(int pIndex, int pValue) {
                }

                public int getCount() {
                    return 1;
                }
            };
        }

        @Nullable
        public Level getWorldLevel() {
            return this.getLevel();
        }

        public boolean exists() {
            return !this.isRemoved();
        }

        public GameTime getUpdateInterval() {
            return this.updateInterval;
        }

        public void onUpdate() {
            if (this.getLevel() != null) {
                if (GameWorld.isServerSide((LevelReader)this.getLevel())) {
                    this.serverTick();
                } else {
                    this.clientTick();
                }
            }
        }

        public TileInventory getTileInventory() {
            return this.inventory;
        }

        public Component getDisplayName() {
            return Component.translatable((String)"container.adpother.filter_frame");
        }

        public RangedWrapper getInputInventory() {
            return new RangedWrapper((IItemHandlerModifiable)this.inventory, 0, 1){

                public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
                    if (slot == 0 && MaterialSlot.isItemValid(inventory, stack)) {
                        return super.insertItem(slot, stack, simulate);
                    }
                    return stack;
                }

                @NotNull
                public ItemStack extractItem(int slot, int amount, boolean simulate) {
                    return ItemStack.EMPTY;
                }
            };
        }

        public RangedWrapper getOutputInventory() {
            return new RangedWrapper(this, (IItemHandlerModifiable)this.inventory, 1, 2){

                @NotNull
                public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
                    return stack;
                }
            };
        }

        protected AbstractContainerMenu createContainer(int id, Player player, net.minecraft.world.entity.player.Inventory playerInventory, TileInventory tileInventory) {
            return new Container(id, playerInventory, tileInventory, this.dataAccess);
        }

        protected void serverTick() {
            IPurifier purifier;
            boolean needSync = false;
            if (this.level != null && ((GameTime)this.airPurifierUpdateInterval.get()).pastIn(this.level)) {
                purifier = this.getAirPurifier().orElse(null);
                if (purifier != null && purifier.isActive((LevelReader)this.level, this.worldPosition)) {
                    if (!this.purifyingAir) {
                        this.purifyingAir = true;
                        needSync = true;
                    }
                    BlockPos outputPos = ((AirPurifier)purifier).getOutputPos((LevelReader)this.level, this.worldPosition);
                    List<PurifiedAir> entities = PurifiedAir.getAllAt(this.level, outputPos);
                    for (Pollutant<?> pollutant : this.getTargetPollutants()) {
                        boolean exists = false;
                        for (PurifiedAir entity : entities) {
                            if (!entity.getPollutant().filter(p -> p == pollutant).isPresent()) continue;
                            exists = true;
                            break;
                        }
                        if (exists) continue;
                        this.level.addFreshEntity((Entity)new PurifiedAir(this.level, outputPos, pollutant, this.worldPosition));
                    }
                } else if (this.purifyingAir) {
                    this.purifyingAir = false;
                    needSync = true;
                }
            }
            if (this.level != null && ((GameTime)this.waterPurifierUpdateInterval.get()).pastIn(this.level)) {
                purifier = this.getWaterPurifier().orElse(null);
                if (purifier != null && purifier.isActive((LevelReader)this.level, this.worldPosition)) {
                    Optional<BlockPos> waterPos;
                    boolean filled;
                    BlockPos abovePos;
                    BlockState aboveState;
                    if (!this.purifyingWater) {
                        this.purifyingWater = true;
                        needSync = true;
                    }
                    if ((aboveState = this.level.getBlockState(abovePos = ((WaterPurifier)purifier).getPumpPos((LevelReader)this.level, this.worldPosition).above())).hasProperty((Property)IWaterLoggable.WATERLOGGED) && !((Boolean)aboveState.getValue((Property)IWaterLoggable.WATERLOGGED)).booleanValue()) {
                        this.level.setBlockAndUpdate(abovePos, (BlockState)aboveState.setValue((Property)IWaterLoggable.WATERLOGGED, (Comparable)Boolean.valueOf(true)));
                    }
                    FilterFrame filter = this.getFilter().orElse(null);
                    List<Pollutant<?>> targetPollutants = this.getTargetPollutants();
                    if (filter != null && !targetPollutants.isEmpty() && (filled = (waterPos = ((WaterPurifier)purifier).findPollutedWater((LevelAccessor)this.level, this.worldPosition, targetPollutants)).flatMap(pos -> PollutedWater.findPollutant((BlockGetter)this.level, pos, targetPollutants)).map(waterPollutant -> filter.fill(this, (Pollutant<?>)((Object)waterPollutant), 1) > 0).orElse(false).booleanValue()) && ((WaterPurifier)purifier).efficiency.takeChance()) {
                        this.level.setBlockAndUpdate(waterPos.get(), Blocks.WATER.defaultBlockState());
                    }
                } else if (this.purifyingWater) {
                    this.purifyingWater = false;
                    needSync = true;
                }
            }
            if (needSync) {
                this.syncWithClients();
            }
        }

        protected void clientTick() {
            if (this.purifyingAir && GameTime.seconds((int)3).pastIn(this.level)) {
                this.getAirPurifier().ifPresent(purifier -> purifier.spawnParticle(this.level, this.worldPosition, ParticleTypes.CLOUD));
            }
            if (this.purifyingWater && GameTime.seconds((float)0.5f).pastIn(this.level)) {
                this.getWaterPurifier().ifPresent(purifier -> purifier.spawnParticle(this.level, this.worldPosition, ParticleTypes.FALLING_WATER));
            }
        }

        public ItemStack getFilterMaterial() {
            return this.getTileInventory().getStackInSlot(0);
        }

        public ItemStack getRenderMaterial() {
            return this.renderMaterial;
        }

        public ItemStack getByproduct() {
            return this.getTileInventory().getStackInSlot(1);
        }

        public boolean isValidFilterMaterial(ItemStack stack) {
            return AdPother.getInstance().pollutants.streamAll().anyMatch(pollutant -> pollutant.getFilterMaterials().contains(stack));
        }

        public boolean isActive() {
            if (this.getLevel() == null) {
                return false;
            }
            if (GameWorld.isServerSide((LevelReader)this.getLevel())) {
                boolean newValue = false;
                if (this.content.hasFunctionalFilters() && (!this.energyStorage.isEnabled() || this.energyStorage.hasEnoughEnergy())) {
                    for (Pollutant<?> pollutant : this.getTargetPollutants()) {
                        if (this.content.getFreeSpaceFor(pollutant) <= 0) continue;
                        newValue = true;
                    }
                }
                if (this.active != newValue) {
                    this.active = newValue;
                }
            }
            return this.active;
        }

        public List<Pollutant<?>> getTargetPollutants() {
            ItemStack material = this.getFilterMaterial();
            if (material.isEmpty()) {
                return Collections.emptyList();
            }
            return AdPother.getInstance().pollutants.streamAll().filter(pollutant -> pollutant.getFilterMaterials().contains(material)).collect(Collectors.toList());
        }

        protected Optional<AirPurifier> getAirPurifier() {
            return this.getFilter().map(filter -> filter.airPurifier);
        }

        protected Optional<WaterPurifier> getWaterPurifier() {
            return this.getFilter().map(filter -> filter.waterPurifier);
        }

        protected Optional<FilterFrame> getFilter() {
            Block block = this.getBlockState().getBlock();
            return block instanceof FilterFrame ? Optional.of((FilterFrame)block) : Optional.empty();
        }

        public static IItemHandler getInventory(BlockTile tile, @Nullable Direction side) {
            if (side != null) {
                return switch (side) {
                    case Direction.UP -> tile.getInputInventory();
                    case Direction.DOWN -> tile.getOutputInventory();
                    default -> new CombinedInvWrapper(new IItemHandlerModifiable[]{tile.getInputInventory(), tile.getOutputInventory()});
                };
            }
            return tile.getTileInventory();
        }

        public static ForgeEnergy.Storage getEnergy(BlockTile tile, @Nullable Direction side) {
            return tile.energyStorage.isEnabled() ? tile.energyStorage : null;
        }

        public void readSharedData(CompoundTag compound, HolderLookup.Provider registries) {
            this.active = compound.getBoolean("active");
            this.purifyingAir = compound.getBoolean("purifyingAir");
            this.purifyingWater = compound.getBoolean("purifyingWater");
            this.content.readFromNBT(compound);
            this.renderMaterial = ItemStack.parseOptional((HolderLookup.Provider)registries, (CompoundTag)compound.getCompound("RenderMaterial"));
            this.energyStorage.readFrom(compound);
            this.partialFullness = compound.getInt("partialFullness");
        }

        public CompoundTag writeSharedData(CompoundTag compound, HolderLookup.Provider registries) {
            compound.putBoolean("active", this.active);
            compound.putBoolean("purifyingAir", this.purifyingAir);
            compound.putBoolean("purifyingWater", this.purifyingWater);
            this.content.writeToNBT(compound);
            compound.put("RenderMaterial", this.renderMaterial.saveOptional(registries));
            this.energyStorage.writeTo(compound);
            compound.putInt("partialFullness", this.partialFullness);
            return compound;
        }
    }

    static class MaterialSlot
    extends TileInventory.ItemSlot {
        public static final int INDEX = 0;

        public MaterialSlot(TileInventory tileInventory, int xPosition, int yPosition) {
            super(tileInventory, 0, xPosition, yPosition);
        }

        public boolean mayPlace(ItemStack stack) {
            return MaterialSlot.isItemValid(this.tileInventory, stack);
        }

        public static boolean isItemValid(TileInventory tileInventory, ItemStack stack) {
            if (tileInventory.getTile() instanceof BlockTile) {
                return ((BlockTile)tileInventory.getTile()).isValidFilterMaterial(stack);
            }
            return false;
        }
    }

    static class ByproductSlot
    extends TileInventory.ItemSlot {
        public static final int INDEX = 1;

        public ByproductSlot(TileInventory tileInventory, int xPosition, int yPosition) {
            super(tileInventory, 1, xPosition, yPosition);
        }

        public boolean mayPlace(ItemStack stack) {
            return false;
        }
    }

    public static class PollutantFilteredMsg
    extends ForgeNetMsg<PollutantFilteredMsg> {
        public int pollutantId;
        public BlockPos pos;

        public PollutantFilteredMsg() {
        }

        public PollutantFilteredMsg(Pollutant<?> pollutant, BlockPos pos) {
            this.pollutantId = Block.getId((BlockState)pollutant.defaultBlockState());
            this.pos = pos;
        }

        public PollutantFilteredMsg create() {
            return new PollutantFilteredMsg();
        }

        public void handle(Level level, Player player) {
            Block block = Block.stateById((int)this.pollutantId).getBlock();
            if (block instanceof Pollutant) {
                Pollutant pollutant = (Pollutant)block;
                block = level.getBlockState(this.pos).getBlock();
                if (block instanceof FilterFrame) {
                    FilterFrame filterFrame = (FilterFrame)block;
                    filterFrame.getTile((BlockGetter)level, this.pos).ifPresent(tile -> {
                        tile.lastFillingTime = CommonTime.Stamp.now();
                        tile.lastFilteredPollutant = pollutant;
                    });
                }
            }
        }
    }

    static class PollutantSlot
    extends TileInventory.ItemSlot {
        public static final int INDEX = 2;

        public PollutantSlot(TileInventory tileInventory, int xPosition, int yPosition) {
            super(tileInventory, 2, xPosition, yPosition);
        }

        public boolean mayPlace(ItemStack stack) {
            return false;
        }

        public boolean mayPickup(Player player) {
            return false;
        }
    }

    public static class Container
    extends TileInventory.AbstractContainer {
        private final ContainerData data;

        public Container(int id, net.minecraft.world.entity.player.Inventory playerInventory, TileInventory tileInventory, ContainerData data) {
            super((MenuType)AdPother.getInstance().containers.filterFrame.get(), id, playerInventory, tileInventory);
            this.data = data;
            this.addSlot((Slot)new MaterialSlot(tileInventory, 56, 17));
            this.addSlot((Slot)new ByproductSlot(tileInventory, 116, 35));
            this.addSlot((Slot)new PollutantSlot(tileInventory, 56, 53));
            this.addPlayerSlots(8, 84);
            this.addDataSlots(data);
        }

        public Percentage getByproductProgress() {
            return Percentage.value((float)this.data.get(0));
        }

        public static class Factory
        implements IContainerFactory<Container> {
            public Container create(int windowId, net.minecraft.world.entity.player.Inventory playerInventory, RegistryFriendlyByteBuf data) {
                HitResult hitResult = Minecraft.getInstance().hitResult;
                if (hitResult instanceof BlockHitResult) {
                    BlockPos pos;
                    BlockHitResult hitResult2 = (BlockHitResult)hitResult;
                    Level level = playerInventory.player.level();
                    BlockEntity blockEntity = level.getBlockEntity(pos = hitResult2.getBlockPos());
                    if (blockEntity instanceof BlockTile) {
                        BlockTile tile = (BlockTile)blockEntity;
                        return new Container(windowId, playerInventory, tile.getTileInventory(), tile.dataAccess);
                    }
                }
                return new Container(windowId, playerInventory, new TileInventory(null, 3), (ContainerData)new SimpleContainerData(1));
            }
        }
    }

    public static class BlockItem
    extends net.minecraft.world.item.BlockItem
    implements IStorageItem {
        public BlockItem(ForgeBlock block, Item.Properties props) {
            super((Block)block, props);
        }

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> lines, TooltipFlag flag) {
            IStorageItem.super.appendHoverText(stack, context, lines, flag);
            super.appendHoverText(stack, context, lines, flag);
        }

        @Override
        public int getInitialCapacity(ItemStack storage) {
            return 0;
        }
    }

    public static class Inventory
    extends TileInventory {
        public Inventory(BlockEntity tile, int size) {
            super(tile, size);
        }

        public int getSlotLimit(int slot) {
            Block block = this.tile.getBlockState().getBlock();
            return block instanceof FilterFrame ? ((FilterFrame)block).slotLimit : 0;
        }

        protected void onContentsChanged(int slot) {
            if (slot != 2 && this.tile.getLevel() != null) {
                this.tile.getLevel().scheduleTick(this.tile.getBlockPos(), this.tile.getBlockState().getBlock(), 1);
            }
            super.onContentsChanged(slot);
        }
    }
}

