/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.compat;

import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.data.INBTSource;
import com.endertech.minecraft.mods.adpother.AdPother;
import com.endertech.minecraft.mods.adpother.events.WorldEvents;
import com.endertech.minecraft.mods.adpother.sources.Emitter;
import com.endertech.minecraft.mods.adpother.sources.Fuel;
import com.endertech.minecraft.mods.adpother.sources.SourceBase;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class ImmersiveAircraft {
    public static Emitter.Properties<?> vehicle() {
        return Emitter.Properties.fuel("").customFactory(Vehicle::new);
    }

    public static class Vehicle
    extends Emitter {
        public static final void onFuelBurned(float amount, Entity entity) {
            Emitter emitter;
            if (amount > 0.0f && (emitter = (Emitter)AdPother.getInstance().emitters.get(entity).orElse(null)) != null && emitter.isActive(INBTSource.of((Entity)entity))) {
                Fuel fuel = new Fuel(null, (SourceBase.Properties<?>)((Object)((SourceBase.Properties)((Object)((SourceBase.Properties)((Object)Emitter.Properties.of().factor(amount * 1.0f / 1600.0f))).carbon(1.0f))).sulfur(0.1f)), false);
                WorldEvents.onFuelBurned(fuel, 5, entity, WorldEvents.Alignment.BACK);
            }
        }

        public static final void onAmmoSpent(ItemStack ammo, Entity entity) {
            Level level = entity.level();
            BlockPos pos = BlockPos.containing((Position)WorldEvents.Alignment.CENTER.getPositionVec(entity));
            ItemStack stack = new ItemStack((ItemLike)ammo.getItem(), 1);
            WorldEvents.onItemBurned(stack, level, pos);
        }

        public Vehicle(UnitConfig config, Emitter.Properties<?> props) {
            super(config, (Emitter.Properties<?>)((Object)props.activeStateHardcoded()));
        }

        public boolean isActive(INBTSource<?> nbtSource) {
            String key;
            CompoundTag compound = nbtSource.serialize();
            int i = 0;
            while (compound.contains(key = "Fuel" + i)) {
                if (compound.getInt(key) > 0) {
                    return true;
                }
                ++i;
            }
            return false;
        }
    }
}

