/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.compat;

import com.endertech.minecraft.forge.ForgeEndertech;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.core.AbstractForgeMod;
import com.endertech.minecraft.forge.data.INBTSource;
import com.endertech.minecraft.mods.adpother.sources.Emitter;
import com.endertech.minecraft.mods.adpother.sources.SourceBase;
import java.lang.reflect.Method;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.common.util.Lazy;

public class ImmersiveEngineering {
    private static final Lazy<Optional<ImmersiveEngineering>> INSTANCE = AbstractForgeMod.singletonInstance((String)"immersiveengineering", ImmersiveEngineering.class);
    private Method iMultiblockContext_getLevel;
    private Method iMultiblockContext_getState;
    private Method iMultiblockLevel_getBlockEntity;
    private Method multiblockBlockEntityMaster_getHelper;
    private Method iMultiblockBEHelperMaster_getContext;

    public static Optional<ImmersiveEngineering> getInstance() {
        return (Optional)INSTANCE.get();
    }

    public static Emitter.Properties<?> fuelBurner() {
        return Emitter.Properties.fuel("active").enumIdAsRelatedBlocks();
    }

    public static Emitter.Properties<?> bucketWheel() {
        return (Emitter.Properties)((Object)((SourceBase.Properties)((Object)Emitter.Properties.tile("active").metadata("[multiblockslave=false]").relatedBlocks("immersiveengineering:bucket_wheel:*"))).dust(1.0f));
    }

    public static Emitter.Properties<?> crusher() {
        return (Emitter.Properties)((Object)((SourceBase.Properties)((Object)((Emitter.Properties)((Object)Emitter.Properties.tile("").metadata("[multiblockslave=false]").customFactory(Crusher::new))).relatedBlocks("immersiveengineering:crusher:*"))).dust(4.0f));
    }

    private ImmersiveEngineering() throws ClassNotFoundException, NoSuchMethodException {
        Class<?> iMultiblockContext = Class.forName("blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockContext");
        this.iMultiblockContext_getLevel = iMultiblockContext.getMethod("getLevel", new Class[0]);
        this.iMultiblockContext_getState = iMultiblockContext.getMethod("getState", new Class[0]);
        Class<?> iMultiblockLevel = Class.forName("blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockLevel");
        this.iMultiblockLevel_getBlockEntity = iMultiblockLevel.getMethod("getBlockEntity", BlockPos.class);
        this.multiblockBlockEntityMaster_getHelper = Class.forName("blusunrize.immersiveengineering.api.multiblocks.blocks.registry.MultiblockBlockEntityMaster").getMethod("getHelper", new Class[0]);
        this.iMultiblockBEHelperMaster_getContext = Class.forName("blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockBEHelperMaster").getMethod("getContext", new Class[0]);
    }

    public Optional<BlockEntity> getBlockEntity(Object iMultiblockContext, BlockPos pos) {
        try {
            Object level = this.iMultiblockContext_getLevel.invoke(iMultiblockContext, new Object[0]);
            BlockEntity tile = (BlockEntity)this.iMultiblockLevel_getBlockEntity.invoke(level, pos);
            return Optional.ofNullable(tile);
        }
        catch (Exception e) {
            ImmersiveEngineering.logError(e.toString());
            return Optional.empty();
        }
    }

    public Optional<Object> getState(BlockEntity multiblockBlockEntityMaster) {
        try {
            Object master = this.multiblockBlockEntityMaster_getHelper.invoke((Object)multiblockBlockEntityMaster, new Object[0]);
            Object context = this.iMultiblockBEHelperMaster_getContext.invoke(master, new Object[0]);
            Object state = this.iMultiblockContext_getState.invoke(context, new Object[0]);
            return Optional.ofNullable(state);
        }
        catch (Exception e) {
            ImmersiveEngineering.logError(e.toString());
            return Optional.empty();
        }
    }

    protected static void logError(String msg) {
        ForgeEndertech.debugMsg((String)("ImmersiveEngineering: " + msg));
    }

    public static class Crusher
    extends Emitter {
        private Method shouldRenderAsActive;

        public Crusher(UnitConfig config, Emitter.Properties<?> props) {
            super(config, (Emitter.Properties<?>)((Object)props.activeStateHardcoded()));
            try {
                this.shouldRenderAsActive = Class.forName("blusunrize.immersiveengineering.common.blocks.multiblocks.logic.CrusherLogic$State").getMethod("shouldRenderActive", new Class[0]);
            }
            catch (Exception e) {
                ImmersiveEngineering.logError(e.toString());
            }
        }

        public boolean isActive(INBTSource<?> nbtSource) {
            Object t;
            if (nbtSource.source().isPresent() && (t = nbtSource.source().get()) instanceof BlockEntity) {
                BlockEntity blockEntity = (BlockEntity)t;
                Object crusherState = ImmersiveEngineering.getInstance().flatMap(ie -> ie.getState(blockEntity)).orElse(null);
                if (crusherState != null && this.shouldRenderAsActive != null) {
                    try {
                        return (Boolean)this.shouldRenderAsActive.invoke(crusherState, new Object[0]);
                    }
                    catch (Exception e) {
                        ImmersiveEngineering.logError(e.toString());
                    }
                }
            }
            return false;
        }
    }
}

