/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.config;

import com.endertech.minecraft.forge.configs.AbstractParsableList;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.core.AbstractForgeMod;
import com.endertech.minecraft.forge.math.Percentage;
import com.endertech.minecraft.forge.units.UnitId;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;

public class ImmuneEntityList
extends AbstractParsableList {
    public static final String SYNTAX = "Syntax: pollutionThreshold% -> entityId \nPollution threshold is the minimum percentage of pollution required to impact the specified entity.";
    protected final Map<EntityType<?>, Percentage> thresholdByEntityType = new ConcurrentHashMap();
    private final String comment;

    public ImmuneEntityList(UnitConfig config, String category, String comment) {
        super(config, category, "immuneEntities", new String[0]);
        this.comment = comment;
    }

    protected String getComment() {
        return this.comment + "\nSyntax: pollutionThreshold% -> entityId \nPollution threshold is the minimum percentage of pollution required to impact the specified entity.";
    }

    protected void parseConfigValues() {
        this.thresholdByEntityType.clear();
        for (String string : this.configValues) {
            List split = this.split(string, "->");
            try {
                if (split.size() != 2) {
                    throw new Exception();
                }
                Percentage threshold = Percentage.parse((String)((String)split.get(0)));
                UnitId id = UnitId.from((String)((String)split.get(1)));
                if (threshold.isLessOrEqualTo((Object)Percentage.ZERO) || id.isEmpty()) {
                    throw new Exception();
                }
                if (!AbstractForgeMod.isLoaded((String)id.getModId())) continue;
                BuiltInRegistries.ENTITY_TYPE.getOptional(id.toResLoc()).ifPresent(type -> this.thresholdByEntityType.put((EntityType<?>)type, threshold));
            }
            catch (Exception e) {
                this.logParsingError(string);
            }
        }
    }

    public boolean isImmune(Entity entity, Percentage pollution) {
        Player player;
        if (entity instanceof Player && ((player = (Player)entity).isSpectator() || player.isCreative())) {
            return true;
        }
        Percentage threshold = this.thresholdByEntityType.get(entity.getType());
        if (threshold != null) {
            return threshold.isGreaterThan((Object)pollution);
        }
        return false;
    }
}

