/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.events;

import com.endertech.minecraft.forge.events.ChunkFullyLoadedEvent;
import com.endertech.minecraft.forge.world.ChunkLoc;
import com.endertech.minecraft.mods.adpother.pollution.ChunkPollution;
import com.endertech.minecraft.mods.adpother.pollution.WorldData;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.level.ChunkDataEvent;
import net.neoforged.neoforge.event.level.ChunkEvent;

@EventBusSubscriber(modid="adpother")
public class ChunkEvents {
    @SubscribeEvent
    public static void onChunkDataLoaded(ChunkDataEvent.Load event) {
        ChunkAccess chunkAccess = event.getChunk();
        if (chunkAccess instanceof LevelChunk) {
            LevelChunk chunk = (LevelChunk)chunkAccess;
            ChunkLoc location = ChunkLoc.from((LevelChunk)chunk);
            ChunkPollution pollution = WorldData.getChunkPollution(chunk.getLevel(), location);
            pollution.readFrom(event.getData());
            pollution.setUnloaded(false);
        }
    }

    @SubscribeEvent
    public static void onChunkDataSaved(ChunkDataEvent.Save event) {
        ChunkAccess chunkAccess = event.getChunk();
        if (chunkAccess instanceof LevelChunk) {
            ChunkLoc location;
            LevelChunk chunk = (LevelChunk)chunkAccess;
            Level level = chunk.getLevel();
            ChunkPollution pollution = WorldData.getChunkPollution(level, location = ChunkLoc.from((LevelChunk)chunk));
            if (!pollution.isEmpty()) {
                pollution.writeTo(event.getData());
            }
            if (pollution.isEmpty() || pollution.isUnloaded()) {
                WorldData.getData(level).removePollutionInfoAt(location);
            }
        }
    }

    @SubscribeEvent
    public static void onChunkLoaded(ChunkFullyLoadedEvent event) {
        LevelChunk chunk = event.getChunk();
        ServerLevel level = event.getLevel();
        WorldData data = WorldData.getData((Level)level);
        for (Map.Entry entry : chunk.getBlockEntities().entrySet()) {
            BlockPos pos = (BlockPos)entry.getKey();
            BlockEntity tile = (BlockEntity)entry.getValue();
            BlockState state = chunk.getBlockState(pos);
            data.addIfEmitter(level, pos, state, tile);
        }
    }

    @SubscribeEvent
    public static void onChunkUnloaded(ChunkEvent.Unload event) {
        ChunkAccess chunkAccess = event.getChunk();
        if (chunkAccess instanceof LevelChunk) {
            LevelChunk chunk = (LevelChunk)chunkAccess;
            Level level = chunk.getLevel();
            ChunkLoc location = ChunkLoc.from((LevelChunk)chunk);
            WorldData data = WorldData.getData(level);
            ChunkPollution pollution = WorldData.getChunkPollution(level, location);
            pollution.setUnloaded(true);
            if (pollution.isEmpty() || level.isClientSide()) {
                data.removePollutionInfoAt(location);
            }
            if (!level.isClientSide()) {
                data.removeTileEmissionsIn(chunk);
            }
        }
    }
}

