/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.init;

import com.endertech.minecraft.forge.core.AbstractForgeMod;
import com.endertech.minecraft.forge.units.RegistryObjectsInit;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.PathType;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.common.SoundActions;
import net.neoforged.neoforge.fluids.FluidInteractionRegistry;
import net.neoforged.neoforge.fluids.FluidType;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class FluidTypes
extends RegistryObjectsInit<FluidType> {
    public final DeferredHolder<FluidType, FluidType> pollutedWaterType = this.register("polluted_water", () -> new FluidType(this, FluidType.Properties.create().descriptionId("block.adpother.polluted_water").fallDistanceModifier(0.0f).canExtinguish(true).canConvertToSource(true).supportsBoating(true).sound(SoundActions.BUCKET_FILL, SoundEvents.BUCKET_FILL).sound(SoundActions.BUCKET_EMPTY, SoundEvents.BUCKET_EMPTY).sound(SoundActions.FLUID_VAPORIZE, SoundEvents.FIRE_EXTINGUISH).canHydrate(true)){

        @Nullable
        public PathType getBlockPathType(FluidState state, BlockGetter level, BlockPos pos, @Nullable Mob mob, boolean canFluidLog) {
            return canFluidLog ? super.getBlockPathType(state, level, pos, mob, true) : null;
        }

        public void initializeClient(Consumer<IClientFluidTypeExtensions> consumer) {
            consumer.accept(new IClientFluidTypeExtensions(this){
                private static final ResourceLocation UNDERWATER_LOCATION = ResourceLocation.withDefaultNamespace((String)"textures/misc/underwater.png");
                private static final ResourceLocation WATER_STILL = ResourceLocation.withDefaultNamespace((String)"block/water_still");
                private static final ResourceLocation WATER_FLOW = ResourceLocation.withDefaultNamespace((String)"block/water_flow");
                private static final ResourceLocation WATER_OVERLAY = ResourceLocation.withDefaultNamespace((String)"block/water_overlay");

                public ResourceLocation getStillTexture() {
                    return WATER_STILL;
                }

                public ResourceLocation getFlowingTexture() {
                    return WATER_FLOW;
                }

                @Nullable
                public ResourceLocation getOverlayTexture() {
                    return WATER_OVERLAY;
                }

                public ResourceLocation getRenderOverlayTexture(Minecraft mc) {
                    return UNDERWATER_LOCATION;
                }

                public int getTintColor() {
                    return -1710797;
                }

                public int getTintColor(FluidState state, BlockAndTintGetter getter, BlockPos pos) {
                    return -1710797;
                }
            });
        }
    });

    public FluidTypes(AbstractForgeMod mod) {
        super(mod, NeoForgeRegistries.Keys.FLUID_TYPES);
    }

    public void addFluidInteractions() {
        FluidInteractionRegistry.addInteraction((FluidType)((FluidType)NeoForgeMod.LAVA_TYPE.value()), (FluidInteractionRegistry.InteractionInformation)new FluidInteractionRegistry.InteractionInformation((FluidType)this.pollutedWaterType.get(), fluidState -> fluidState.isSource() ? Blocks.OBSIDIAN.defaultBlockState() : Blocks.COBBLESTONE.defaultBlockState()));
    }
}

