/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.init;

import com.endertech.minecraft.forge.configs.IForgeEnum;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.core.AbstractForgeMod;
import com.endertech.minecraft.forge.items.ForgeItem;
import com.endertech.minecraft.forge.math.Percentage;
import com.endertech.minecraft.forge.units.IRelatedUnit;
import com.endertech.minecraft.forge.units.RelatedUnitsInit;
import com.endertech.minecraft.forge.units.UnitId;
import com.endertech.minecraft.mods.adpother.emissions.Emissions;
import com.endertech.minecraft.mods.adpother.sources.Emitter;
import com.endertech.minecraft.mods.adpother.sources.Fuel;
import com.endertech.minecraft.mods.adpother.sources.SourceBase;
import java.util.Collection;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.world.item.ItemStack;

public class Fuels
extends RelatedUnitsInit<Fuel, BuiltInFuels> {
    public Fuels(AbstractForgeMod mod) {
        super(mod, BuiltInFuels.class);
    }

    private static boolean isLiquid(String name) {
        return name.startsWith("fluid$");
    }

    public Fuel createCustomUnitFrom(UnitConfig config, String name) {
        return new Fuel(config, SourceBase.Properties.of(), Fuels.isLiquid(name));
    }

    public Fuel createDefaultUnitFrom(UnitConfig config, BuiltInFuels e) {
        return new Fuel(config, e.props.get(), Fuels.isLiquid(e.getName()));
    }

    public static Optional<Emissions> defaultEmissionsFor(ItemStack stack) {
        int burnTime = ForgeItem.getMaxBurnTime((ItemStack)stack);
        if (burnTime > 0) {
            double carbon = (double)burnTime / 1600.0;
            double sulfur = carbon / 10.0;
            Emissions emissions = Emissions.of().carbon((float)carbon).sulfur((float)sulfur);
            return Optional.of(emissions);
        }
        return Optional.empty();
    }

    protected void attachToFluids(Fuel unit) {
        Collection fluids;
        UnitId id = unit.getRelatedId();
        if (id.isTag() && id.getModId().equals("c") && (fluids = (id = new UnitId("neoforge", id.getRegName(), id.getMetaData(), true)).getAllMatchedFluids()) != null) {
            fluids.forEach(fluid -> this.allFluids.put(fluid, unit));
        }
        super.attachToFluids((IRelatedUnit)unit);
    }

    public Optional<Fuel> get(ItemStack stack) {
        Optional<Emissions> emissions;
        Fuel fuel = super.get(stack).orElse(null);
        if (fuel == null && (emissions = Fuels.defaultEmissionsFor(stack)).isPresent()) {
            fuel = new Fuel(null, (SourceBase.Properties<?>)((Object)Emitter.Properties.of().emissions(emissions.get())), false);
        }
        return Optional.ofNullable(fuel);
    }

    static enum BuiltInFuels implements IForgeEnum
    {
        group$arrows("#minecraft:arrows", 0.0625),
        group$banners("#minecraft:banners", 0.1875),
        group$bio_fuels("#c:fuels/bio", 0.0625, 0.0),
        group$blaze_rods("#c:rods/blaze", 1.2, 0.6),
        group$beds("#minecraft:beds", 0.75),
        group$boats("#minecraft:boats", 0.75),
        group$bookshelves("#c:bookshelves", 0.1875),
        group$carpets("#minecraft:carpets", 0.335),
        group$carrots("#c:crops/carrot", 0.0625),
        group$charcoal("#c:charcoal", 1.0),
        group$charcoal_dust("#c:dusts/charcoal", 0.8),
        group$charcoal_blocks("#c:storage_blocks/charcoal", 9.0),
        group$coal_blocks("#c:storage_blocks/coal", 9.0),
        group$coal_coke("#c:coal_coke", 2.0),
        group$coal_coke_dust("#c:dusts/coal_coke", 1.6),
        group$coal_coke_blocks("#c:storage_blocks/coal_coke", 18.0),
        group$crops("#c:crops", 0.0625),
        group$ender_pearls("#c:ender_pearls", 0.6, 0.3),
        group$gunpowder("#c:gunpowder", 0.8, 0.4),
        group$feathers("#c:feathers", 0.0625),
        group$fishes("#minecraft:fishes", 0.125),
        group$leaves("#minecraft:leaves", 0.1875),
        group$logs("#minecraft:logs", 0.1875),
        group$mushrooms("#c:mushrooms", 0.0625),
        group$nether_stars("#c:nether_stars", 50.0, 25.0),
        group$rails("#minecraft:rails", 0.0625),
        group$saplings("#minecraft:saplings", 0.0625),
        group$seeds("#c:seeds", 0.0625),
        group$signs("#minecraft:signs", 0.35),
        group$small_flowers("#minecraft:small_flowers", 0.0625),
        group$tall_flowers("#minecraft:tall_flowers", 0.125),
        group$lectern_books("#minecraft:lectern_books", 0.55),
        group$planks("#minecraft:planks", 0.1875),
        group$sulfur_dust("#c:dusts/sulfur", 0.08, 0.8),
        group$wooden_fences("#c:fences/wooden", 0.1875),
        group$wooden_fence_gates("#c:fence_gates/wooden", 0.1875),
        group$wooden_slabs("#minecraft:wooden_slabs", 0.075),
        group$wooden_buttons("#minecraft:wooden_buttons", 0.0625),
        group$wooden_chests("#c:chests/wooden", 0.1875),
        group$wooden_doors("#minecraft:wooden_doors", 0.1875),
        group$wooden_pressure_plates("#minecraft:wooden_pressure_plates", 0.1875),
        group$wooden_rods("#c:rods/wooden", 0.0625),
        group$wooden_trapdoors("#minecraft:wooden_trapdoors", 0.1875),
        group$wooden_stairs("#minecraft:wooden_stairs", 0.1875),
        group$wool("#minecraft:wool", 0.0625),
        fluid$benzene(7.62, Percentage.value((float)0.0f)),
        fluid$biodiesel(4.18, Percentage.value((float)10.0f)),
        fluid$bioethanol(1.52, Percentage.value((float)0.0f)),
        fluid$biofuel(1.52, Percentage.value((float)0.0f)),
        fluid$biogas(2.32, Percentage.value((float)10.0f)),
        fluid$biomass(1.52, Percentage.value((float)0.0f)),
        fluid$butane(5.08, Percentage.value((float)0.0f)),
        fluid$butene(5.08, Percentage.value((float)0.0f)),
        fluid$createtfmg$carbon_dioxide("tfmg:carbon_dioxide", 1.27, 0.0),
        fluid$createtfmg$flowing_carbon_dioxide("tfmg:flowing_carbon_dioxide", 1.27, 0.0),
        fluid$creosote(5.1, Percentage.value((float)10.0f)),
        fluid$crudeoil(11.17, Percentage.value((float)40.0f)),
        fluid$diesel(4.46, Percentage.value((float)5.0f)),
        fluid$ethane(2.54, Percentage.value((float)0.0f)),
        fluid$ethanol(2.54, Percentage.value((float)0.0f)),
        fluid$ethylene(2.54, Percentage.value((float)0.0f)),
        fluid$fishoil(0.4, Percentage.value((float)0.0f)),
        fluid$fuelium("vehicle:fuelium", 0.06, 0.006),
        fluid$gas(2.32, Percentage.value((float)10.0f)),
        fluid$gasoline(4.06, Percentage.value((float)3.0f)),
        fluid$kerosene(4.12, Percentage.value((float)10.0f)),
        fluid$lava("#minecraft:lava", 4.0, 0.4),
        fluid$lpg(1.05, Percentage.value((float)0.0f)),
        fluid$methane(1.27, Percentage.value((float)0.0f)),
        fluid$methanol(1.27, Percentage.value((float)10.0f)),
        fluid$naphtha(2.32, Percentage.value((float)10.0f)),
        fluid$nitan(4.0, Percentage.value((float)10.0f)),
        fluid$octane(10.16, Percentage.value((float)4.0f)),
        fluid$petrol(4.06, Percentage.value((float)3.0f)),
        fluid$petrolium(11.17, Percentage.value((float)40.0f)),
        fluid$phenol(7.62, Percentage.value((float)0.0f)),
        fluid$plantoil(0.4, Percentage.value((float)0.0f)),
        fluid$propane(3.81, Percentage.value((float)0.0f)),
        minecraft$apple(0.0625),
        minecraft$golden_apple(0.125),
        minecraft$armor_stand(0.3),
        minecraft$beef(0.125),
        minecraft$blaze_powder(0.6, 0.3),
        minecraft$book(0.5),
        minecraft$bow(0.1875),
        minecraft$bowl(0.0625),
        minecraft$cactus(0.1875),
        minecraft$carrot_on_a_stick(0.1875),
        minecraft$chicken(0.125),
        minecraft$cobweb(0.125),
        minecraft$chorus_plant(0.3),
        minecraft$chorus_flower(0.3),
        minecraft$coal(1.0),
        minecraft$charcoal(1.0),
        minecraft$crafting_table(0.1875),
        minecraft$crossbow(0.1875),
        minecraft$daylight_detector(0.1875),
        minecraft$deadbush(0.125),
        minecraft$dragon_breath(1.05, 0.525),
        minecraft$dried_kelp_block(0.25),
        minecraft$ender_eye(0.6, 0.3),
        minecraft$fire_charge(0.75, 0.325),
        minecraft$firework_rocket(2.55),
        minecraft$firework_star(1.2, 0.6),
        minecraft$fishing_rod(0.125),
        minecraft$ghast_tear(1.0, 0.5),
        minecraft$grass(0.125),
        minecraft$hay_block(0.45),
        minecraft$item_frame(0.45),
        minecraft$jukebox(0.1875),
        minecraft$ladder(0.1875),
        minecraft$lever(0.0625),
        minecraft$lily_pad(0.0625),
        minecraft$magma_cream(1.0, 0.5),
        minecraft$map(1.25),
        minecraft$mutton(0.125),
        minecraft$note_block(0.1875),
        minecraft$painting(0.5),
        minecraft$paper(0.1875),
        minecraft$piston(0.5),
        minecraft$poisonous_potato(0.0625),
        minecraft$porkchop(0.125),
        minecraft$potion(0.0625),
        minecraft$rabbit(0.125),
        minecraft$redstone_torch(0.0625),
        minecraft$rotten_flesh(0.125, 0.3),
        minecraft$seagrass(0.125),
        minecraft$shield(0.9),
        minecraft$short_grass(0.125),
        minecraft$spider_eye(0.0625),
        minecraft$sticky_piston(0.5),
        minecraft$sugar_cane(0.0625),
        minecraft$tall_grass(0.125),
        minecraft$tnt(4.05, 2.025),
        minecraft$tnt_minecart(4.1, 2.05),
        minecraft$torch(0.0625),
        minecraft$soul_torch(0.0625, 0.125),
        minecraft$tripwire_hook(0.125),
        minecraft$vine(0.0625),
        minecraft$wooden_axe(0.125),
        minecraft$wooden_hoe(0.125),
        minecraft$wooden_pickaxe(0.125),
        minecraft$wooden_shovel(0.125),
        minecraft$wooden_sword(0.125),
        burningfurnace$burned_food_powder(0.4),
        rftoolspower$blazing_rod(1.2, 0.6),
        tfc$peat(0.8),
        unlit$coal_dust(0.25);

        final Supplier<SourceBase.Properties<?>> props;

        private BuiltInFuels(double carbon) {
            this("", carbon);
        }

        private BuiltInFuels(double carbon, double sulfur) {
            this("", carbon, sulfur);
        }

        private BuiltInFuels(double carbon, Percentage sulfur) {
            this(carbon, carbon * (double)sulfur.toFraction());
        }

        private BuiltInFuels(String id, double carbon) {
            this(id, carbon, carbon / 10.0);
        }

        private BuiltInFuels(String id, double carbon, double sulfur) {
            this(id, () -> Emissions.of().carbon((float)carbon).sulfur((float)sulfur));
        }

        private BuiltInFuels(String id, Supplier<Emissions> emissions) {
            if (((String)id).isEmpty() && Fuels.isLiquid(this.getName())) {
                id = "#c:" + UnitId.from((Enum)this, (String)"").getRegName();
            }
            String finalId = id;
            this.props = () -> ((SourceBase.Properties)((SourceBase.Properties)SourceBase.Properties.of().id(finalId)).emptyToEnumId(this, true)).emissions((Emissions)emissions.get());
        }
    }
}

