/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.init;

import com.endertech.common.CommonTime;
import com.endertech.common.IntBounds;
import com.endertech.minecraft.forge.configs.ColorARGB;
import com.endertech.minecraft.forge.configs.IForgeEnum;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.core.AbstractForgeMod;
import com.endertech.minecraft.forge.data.TagHelper;
import com.endertech.minecraft.forge.entities.ForgeEffect;
import com.endertech.minecraft.forge.entities.ForgeEntity;
import com.endertech.minecraft.forge.items.ForgeItem;
import com.endertech.minecraft.forge.math.GameBounds;
import com.endertech.minecraft.forge.units.RelatedUnit;
import com.endertech.minecraft.forge.units.RelatedUnitsInit;
import com.endertech.minecraft.forge.units.UnitId;
import com.endertech.minecraft.mods.adpother.AdPother;
import com.endertech.minecraft.mods.adpother.init.Pollutants;
import com.endertech.minecraft.mods.adpother.pollution.IStorage;
import com.endertech.minecraft.mods.adpother.pollution.IStorageItem;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import org.apache.commons.lang3.tuple.Pair;

public class Respirators
extends RelatedUnitsInit<Respirator, BuiltIn> {
    public Respirators(AbstractForgeMod mod) {
        super(mod, BuiltIn.class);
    }

    public Respirator createCustomUnitFrom(UnitConfig config, String name) {
        return new Respirator(config, UnitId.EMPTY, 0, "");
    }

    public Respirator createDefaultUnitFrom(UnitConfig config, BuiltIn e) {
        return e.createRespirator(config, UnitId.from((Enum)e, (String)"*"));
    }

    public Optional<Holder<MobEffect>> getEffect() {
        return Optional.of(AdPother.getInstance().effects.respirator);
    }

    public CommonTime.Interval getEffectDurationFor(Respirator respirator, ItemStack stack, int damage) {
        if (damage > 0) {
            IStorage.Content content = respirator.getContent(stack);
            double seconds = content.hasFunctionalFilters() ? (double)(content.getCapacity() - content.getHighestFullness()) : 0.0;
            seconds /= (double)damage;
            seconds = Math.max(2.0, seconds);
            return CommonTime.Interval.seconds((double)seconds);
        }
        return CommonTime.Interval.hours((double)1.0);
    }

    public Optional<Pair<ItemStack, Respirator>> findOn(LivingEntity living, boolean onlyFunctional) {
        for (ItemStack stack : ForgeEntity.getEquipmentOn((Entity)living)) {
            Respirator respirator = this.get(stack).orElse(null);
            if (respirator == null || onlyFunctional && !respirator.isFunctional(stack)) continue;
            return Optional.of(Pair.of((Object)stack, (Object)respirator));
        }
        return Optional.empty();
    }

    public void updateEffectFor(LivingEntity living, int damage) {
        this.getEffect().ifPresent(arg_0 -> ((LivingEntity)living).removeEffect(arg_0));
        this.findOn(living, true).ifPresent(pair -> {
            CommonTime.Interval duration = this.getEffectDurationFor((Respirator)pair.getRight(), (ItemStack)pair.getLeft(), damage);
            this.getEffect().ifPresent(holder -> living.addEffect(ForgeEffect.createInstance((Holder)holder, (CommonTime.Interval)duration, (boolean)false)));
        });
    }

    static enum BuiltIn implements IForgeEnum
    {
        adpother$iron_respirator(600),
        adpother$gold_respirator(720),
        adpother$diamond_respirator(1440),
        create$copper_diving_helmet(600),
        create$netherite_diving_helmet(1440),
        electrodynamics$compositearmorhelmet(720),
        electrodynamics$combatarmorhelmet(1440),
        hbm$m65_mask("hfrFilter/Count", 600),
        mekanism$scuba_mask(600),
        mekanism$hazmat_mask(600),
        mekanism$mekasuit_helmet(1440);

        public final int durability;
        public final String functionalStateTag;

        private BuiltIn(String functionalStateTag, int durability) {
            this.durability = durability;
            this.functionalStateTag = functionalStateTag;
        }

        private BuiltIn(int durability) {
            this("", durability);
        }

        Respirator createRespirator(UnitConfig config, UnitId id) {
            return new Respirator(config, id, this.durability, this.functionalStateTag);
        }
    }

    public static class Respirator
    extends RelatedUnit
    implements IStorageItem {
        public final int durability;
        private final String functionalStateTag;

        public Respirator(UnitConfig config, UnitId id, int durability, String functionalStateTag) {
            super(config, id);
            String category = this.getClassCategory();
            this.durability = UnitConfig.getInt((UnitConfig)config, (String)category, (String)"durability", (int)durability, (IntBounds)GameBounds.DURABILITY.getIntBounds(), (String)"How long (in seconds) this respirator can withstand low-level pollution.");
            this.functionalStateTag = UnitConfig.getStr((UnitConfig)config, (String)category, (String)"functionalStateTag", (String)functionalStateTag, (String)"The name of the NBT tag that stores info about the active state.\nRespirator is considered functional only if the returning value is > 0 or true.\nSet empty string for no checks");
            this.saveConfig();
        }

        public boolean isFunctional(ItemStack stack) {
            CustomData data;
            if (ForgeItem.isBroken((ItemStack)stack)) {
                return false;
            }
            if (!this.functionalStateTag.isEmpty() && (data = (CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).contains(this.functionalStateTag)) {
                TagHelper.KeyPathPair pair = TagHelper.KeyPathPair.parse((String)this.functionalStateTag);
                int value = TagHelper.getNestedCompound((CompoundTag)data.copyTag(), (String)pair.path()).map(tag -> tag.getInt(pair.key())).orElse(0);
                if (value <= 0) {
                    return false;
                }
            }
            return this.getContent(stack).hasFunctionalFilters();
        }

        public String getTagName() {
            return this.functionalStateTag;
        }

        @Override
        public int getInitialCapacity(ItemStack storage) {
            return this.durability;
        }
    }

    public static class RespiratorEffect
    extends ForgeEffect {
        protected RespiratorEffect() {
            super(MobEffectCategory.BENEFICIAL, ColorARGB.DEFAULT);
        }

        public int getColor() {
            return Pollutants.BuiltIn.CARBON.get().getColor().getARGB();
        }

        public boolean applyEffectTick(LivingEntity living, int amplifier) {
            return true;
        }
    }
}

