/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.pollution;

import com.endertech.common.Args;
import com.endertech.common.CommonMath;
import com.endertech.common.CommonString;
import com.endertech.minecraft.forge.blocks.IEmitter;
import com.endertech.minecraft.forge.configs.MultiConfigProperty;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.world.BiomeId;
import com.endertech.minecraft.forge.world.ChunkBounds;
import com.endertech.minecraft.forge.world.ChunkLoc;
import com.endertech.minecraft.mods.adpother.AdPother;
import com.endertech.minecraft.mods.adpother.blocks.Pollutant;
import com.endertech.minecraft.mods.adpother.emissions.Emission;
import com.endertech.minecraft.mods.adpother.entities.GasEntity;
import com.endertech.minecraft.mods.adpother.pollution.AbstractPollution;
import com.endertech.minecraft.mods.adpother.pollution.PollutionInfo;
import com.endertech.minecraft.mods.adpother.pollution.WorldData;
import com.endertech.minecraft.mods.adpother.sources.Emitter;
import com.endertech.minecraft.mods.adpother.sources.Fuel;
import com.endertech.minecraft.mods.adpother.sources.SourceBase;
import java.util.Locale;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AABB;

public class ChunkPollution
extends AbstractPollution {
    private final ChunkLoc location;
    private boolean unloaded = false;

    public ChunkPollution(ChunkLoc location) {
        this.location = location;
    }

    public void increaseBy(Emitter emitter, IEmitter.Type type, ServerLevel level, BlockPos pos, Fuel fuel, int amount) {
        BiomeId biome = BiomeId.from((LevelAccessor)level, (BlockPos)pos);
        for (Pollutant<?> pollutant : fuel.getPollutants()) {
            BlockEntity tile;
            if (!pollutant.inAllowableDimension(level)) continue;
            float biomeRate = pollutant.getEmissionRateIn(biome);
            float emitterRate = emitter.getEmissionOf(pollutant);
            double totalAmount = (double)((float)amount * fuel.getEmissionOf(pollutant) * biomeRate * emitterRate) * (Double)Emission.globalRate.get();
            int intAmount = this.getIntAndUpdateFractAmount(pollutant, totalAmount);
            if (intAmount <= 0) continue;
            if (type.isTile() && level.isLoaded(pos) && (tile = level.getBlockEntity(pos)) != null) {
                WorldData.scheduleEmissionFor(tile, emitter, pollutant, intAmount);
                continue;
            }
            if (!level.isAreaLoaded(pos, 1)) continue;
            pollutant.generateAt((WorldGenLevel)level, pos, intAmount, 1);
        }
    }

    public void increaseBy(SourceBase source, float factor, ServerLevel level, BlockPos pos) {
        BiomeId biome = BiomeId.from((LevelAccessor)level, (BlockPos)pos);
        for (Pollutant<?> pollutant : source.getPollutants()) {
            BlockEntity tile;
            Emitter emitter;
            if (!pollutant.inAllowableDimension(level)) continue;
            float biomeRate = pollutant.getEmissionRateIn(biome);
            double totalAmount = (double)(factor * source.getEmissionOf(pollutant) * biomeRate) * (Double)Emission.globalRate.get();
            int intAmount = this.getIntAndUpdateFractAmount(pollutant, totalAmount);
            if (intAmount <= 0) continue;
            if (source instanceof Emitter && (emitter = (Emitter)source).getType().isTile() && level.isLoaded(pos) && (tile = level.getBlockEntity(pos)) != null) {
                WorldData.scheduleEmissionFor(tile, emitter, pollutant, intAmount);
                continue;
            }
            if (!level.isAreaLoaded(pos, 1)) continue;
            pollutant.generateAt((WorldGenLevel)level, pos, intAmount, 1);
        }
    }

    protected int getIntAndUpdateFractAmount(Pollutant<?> pollutant, double amount) {
        if (CommonMath.notZero((double)amount)) {
            PollutionInfo info = this.getOrCreateInfoFor(pollutant);
            double fractAmount = info.getFraction() + amount;
            int intAmount = Mth.floor((double)fractAmount);
            info.setFraction(fractAmount -= (double)intAmount);
            return intAmount;
        }
        return 0;
    }

    public void increaseBy(ServerLevel level, BlockPos pos, BlockState state, int blocksAmount) {
        Pollutant pollutant;
        Block block;
        if (state != null && (block = state.getBlock()) instanceof Pollutant && (pollutant = (Pollutant)block).affectsPollutionLevel((LevelAccessor)level, pos, state)) {
            int amount = pollutant.getCarriedPollutionAmount(state) * blocksAmount;
            this.increaseBy(level, pollutant, amount);
        }
    }

    protected void increaseBy(ServerLevel level, Pollutant<?> pollutant, int amount) {
        if (amount != 0) {
            PollutionInfo info = this.getOrCreateInfoFor(pollutant);
            info.increaseQuantity(amount);
        }
    }

    public ChunkLoc getLocation() {
        return this.location;
    }

    public void clean(ServerLevel level) {
        ChunkBounds bounds = this.getLocation().getBounds((LevelHeightAccessor)level);
        int x = bounds.getX().getMin();
        while (bounds.getX().encloses(Integer.valueOf(x))) {
            int z = bounds.getZ().getMin();
            while (bounds.getZ().encloses(Integer.valueOf(z))) {
                int y = bounds.getY().getMin();
                while (bounds.getY().encloses(Integer.valueOf(y))) {
                    BlockPos pos = new BlockPos(x, y, z);
                    Block block = level.getBlockState(pos).getBlock();
                    if (block instanceof Pollutant) {
                        level.removeBlock(pos, false);
                    }
                    ++y;
                }
                ++z;
            }
            ++x;
        }
        AABB chunkAABB = this.getLocation().getBounds((LevelHeightAccessor)level).toAABB();
        level.getEntities(EntityTypeTest.forClass(GasEntity.class), chunkAABB, gas -> true).forEach(gas -> gas.discard());
        this.getLocation().getChunk((Level)level).ifPresent(chunk -> chunk.setUnsaved(true));
        this.infoForPollutant.clear();
    }

    public void recalculate(Level level) {
        this.getInfos().forEach(info -> info.setQuantity(0));
        ChunkBounds bounds = this.getLocation().getBounds((LevelHeightAccessor)level);
        bounds.forEach(pos -> {
            Pollutant pollutant;
            BlockState state = level.getBlockState((BlockPos)pos);
            Block patt0$temp = state.getBlock();
            if (patt0$temp instanceof Pollutant && (pollutant = (Pollutant)patt0$temp).affectsPollutionLevel((LevelAccessor)level, (BlockPos)pos, state)) {
                int amount = pollutant.getCarriedPollutionAmount(state);
                this.getOrCreateInfoFor(pollutant).increaseQuantity(amount);
            }
        });
        this.getLocation().getChunk(level).ifPresent(chunk -> chunk.setUnsaved(true));
    }

    public boolean isUnloaded() {
        return this.unloaded;
    }

    public void setUnloaded(boolean value) {
        this.unloaded = value;
    }

    public String toString() {
        return this.getClass().getSimpleName() + Args.group((Object[])new Object[]{this.getInfos(), Args.get((String)"location", (Object)this.getLocation())});
    }

    public static enum Influence {
        ALWAYS,
        CLOUD,
        NEVER;


        public static class Property<K>
        extends MultiConfigProperty.BaseProperty<K, Influence> {
            public static <K> Property<K> create(UnitConfig config, String category, String name, Influence defaultValue, String comment) {
                Property<K> property = new Property<K>(config, category, name, defaultValue, comment);
                property.defaultValue = property.getFrom(config, category, defaultValue);
                return property;
            }

            protected Property(UnitConfig config, String category, String name, Influence defaultValue, String comment) {
                super(config, category, name, (Object)defaultValue, comment);
            }

            public Influence getFrom(UnitConfig config, String category, Influence defaultValue) {
                String name = UnitConfig.getStr((UnitConfig)config, (String)category, (String)this.getName(), (String)defaultValue.name(), (String)this.getComment());
                try {
                    return Influence.valueOf(name.toUpperCase(Locale.ROOT));
                }
                catch (Exception e) {
                    AdPother.getInstance().getLogger().error("Failed to get ChunkPollution.Influence value for " + CommonString.doubleQuoted((String)name) + " in " + String.valueOf(config.getConfigFile()));
                    return defaultValue;
                }
            }
        }
    }
}

