/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.pollution;

import com.endertech.common.Args;
import com.endertech.common.CommonMath;
import com.endertech.minecraft.forge.blocks.ForgeBlock;
import com.endertech.minecraft.forge.data.INBTSerializable;
import com.endertech.minecraft.forge.math.Percentage;
import com.endertech.minecraft.forge.world.BiomeId;
import com.endertech.minecraft.mods.adpother.blocks.Pollutant;
import java.util.Optional;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class PollutionInfo
implements INBTSerializable<PollutionInfo> {
    private Pollutant<?> pollutant;
    private int quantity = 0;
    private double fraction = 0.0;
    private boolean dirty = false;
    public static final String FLOAT_VALUE_FORMAT = "%.4f";

    public PollutionInfo(Pollutant<?> pollutant) {
        this.pollutant = pollutant;
    }

    public float getFactorIn(BiomeId biome) {
        int criticalAmount = this.getCriticalAmountIn(biome);
        if (criticalAmount == 0) {
            return 0.0f;
        }
        return (float)this.getQuantity() / (float)criticalAmount;
    }

    public Percentage getPercentageIn(BiomeId biome) {
        return Percentage.from((float)this.getFactorIn(biome));
    }

    public Pollutant<?> getPollutant() {
        return this.pollutant;
    }

    public int getCriticalAmountIn(BiomeId biome) {
        return this.pollutant.getCriticalAmountIn(biome);
    }

    public int getQuantity() {
        return this.quantity;
    }

    public double getFraction() {
        return this.fraction;
    }

    public String getFormatedQuantity() {
        return String.format(FLOAT_VALUE_FORMAT, (double)this.getQuantity() + this.getFraction());
    }

    public String toChatString(BiomeId biome) {
        return Args.get((String)(String.valueOf(this.getPollutant().getTextColor()) + this.getPollutant().getSimpleName()), (Object)this.getFormatedQuantity()) + " " + this.getPercentageIn(biome).toColoredText();
    }

    public String toString() {
        return this.getClass().getSimpleName() + Args.group((Object[])new Object[]{Args.get((String)"pollutant", (Object)this.getPollutant().getSimpleName()), Args.get((String)"amount", (Object)this.getFormatedQuantity())});
    }

    public void setFraction(double fractAmount) {
        if (this.fraction != fractAmount) {
            this.fraction = fractAmount;
            this.setDirty(true);
        }
    }

    public void setQuantity(int amount) {
        if (this.quantity != amount) {
            this.quantity = amount;
            this.setDirty(true);
        }
    }

    protected void setPollutant(Pollutant<?> pollutant) {
        if (this.pollutant != pollutant) {
            this.pollutant = pollutant;
            this.setDirty(true);
        }
    }

    public void increaseQuantity(int number) {
        this.setQuantity(this.getQuantity() + number);
    }

    public boolean isEmpty() {
        return this.getPollutant() == null || this.getQuantity() == 0 && CommonMath.isAlmostZero((double)this.getFraction());
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    public void markDirty() {
        this.setDirty(true);
    }

    public PollutionInfo readFrom(CompoundTag compound) {
        Block block = Optional.of(compound.getString("pollutant")).filter(name -> !name.isEmpty()).map(ResourceLocation::tryParse).flatMap(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.BLOCK).getOptional(arg_0)).orElseGet(() -> ((BlockState)Block.stateById((int)compound.getInt("pollutantID"))).getBlock());
        if (block instanceof Pollutant) {
            Pollutant pollutant = (Pollutant)block;
            this.setPollutant(pollutant);
            this.setQuantity(compound.getInt("quantity"));
            this.setFraction(compound.getDouble("fraction"));
        }
        return this;
    }

    public CompoundTag writeTo(CompoundTag compound) {
        compound.putString("pollutant", ForgeBlock.getRegistryName(this.getPollutant()).toString());
        compound.putInt("quantity", this.getQuantity());
        compound.putDouble("fraction", this.getFraction());
        return compound;
    }
}

