/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.pollution;

import com.endertech.minecraft.forge.configs.ColorARGB;
import com.endertech.minecraft.forge.math.GameBounds;
import com.endertech.minecraft.forge.math.Percentage;
import com.endertech.minecraft.mods.adpother.AdPother;
import com.endertech.minecraft.mods.adpother.blocks.Pollutant;
import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class PollutionParticle {
    public static <T extends Options> ParticleType<T> simpleParticleType(T options) {
        final MapCodec codec = MapCodec.unit(options);
        final StreamCodec streamCodec = StreamCodec.unit(options);
        return new ParticleType<T>(false){

            public MapCodec<T> codec() {
                return codec;
            }

            public StreamCodec<? super RegistryFriendlyByteBuf, T> streamCodec() {
                return streamCodec;
            }
        };
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Instance
    extends TextureSheetParticle {
        public Instance(ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, SpriteSet sprite, Percentage influence, Pollutant<?> pollutant) {
            super(level, x, y, z, xSpeed, ySpeed, zSpeed);
            this.setSize(0.02f, 0.02f);
            this.hasPhysics = false;
            this.xd = xSpeed;
            this.yd *= (double)0.1f;
            this.zd = zSpeed;
            float factor = influence.toFraction();
            this.quadSize *= this.random.nextFloat() * 0.6f + 0.5f;
            this.lifetime = (int)(20.0 / ((double)this.random.nextFloat() * 0.8 + 0.2));
            this.alpha = GameBounds.FACTOR.getFloatBounds().interpolateUp(factor).floatValue();
            this.pickSprite(sprite);
            ColorARGB color = pollutant.getColor();
            this.setColor(color.getRed().toFloat(), color.getGreen().toFloat(), color.getBlue().toFloat());
        }

        public ParticleRenderType getRenderType() {
            return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Provider
    implements ParticleProvider<Options> {
        protected final SpriteSet sprite;

        public Provider(SpriteSet sprite) {
            this.sprite = sprite;
        }

        @Nullable
        public Particle createParticle(Options options, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new Instance(level, x, y, z, xSpeed, ySpeed, zSpeed, this.sprite, options.influence, options.pollutant);
        }
    }

    public static class Options
    implements ParticleOptions {
        public final Percentage influence;
        public final Pollutant<?> pollutant;

        public Options(Percentage influence, Pollutant<?> pollutant) {
            this.influence = influence;
            this.pollutant = pollutant;
        }

        public ParticleType<?> getType() {
            return (ParticleType)AdPother.getInstance().particles.pollution.get();
        }
    }
}

