/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.pollution;

import com.endertech.minecraft.forge.world.BiomeId;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.state.BlockState;

public class TickActions {
    private LinkedHashMap<String, ITickAction> actions = new LinkedHashMap();

    public boolean isEmpty() {
        return this.actions.isEmpty();
    }

    public TickActions put(String name, ITickAction action) {
        this.actions.put(name, action);
        return this;
    }

    public TickActions putAfter(String target, String name, ITickAction action) {
        if (target.equals(name)) {
            return this.replace(name, action);
        }
        if (this.actions.containsKey(target)) {
            this.actions.remove(name);
            LinkedHashMap<String, ITickAction> newActions = new LinkedHashMap<String, ITickAction>();
            for (Map.Entry<String, ITickAction> entry : this.actions.entrySet()) {
                newActions.put(entry.getKey(), entry.getValue());
                if (!entry.getKey().equals(target)) continue;
                newActions.put(name, action);
            }
            this.actions = newActions;
        }
        return this;
    }

    public TickActions putBefore(String target, String name, ITickAction action) {
        if (target.equals(name)) {
            return this.replace(name, action);
        }
        if (this.actions.containsKey(target)) {
            this.actions.remove(name);
            LinkedHashMap<String, ITickAction> newActions = new LinkedHashMap<String, ITickAction>();
            for (Map.Entry<String, ITickAction> entry : this.actions.entrySet()) {
                if (entry.getKey().equals(target)) {
                    newActions.put(name, action);
                }
                newActions.put(entry.getKey(), entry.getValue());
            }
            this.actions = newActions;
        }
        return this;
    }

    public TickActions putFirst(String name, ITickAction action) {
        this.actions.putFirst(name, action);
        return this;
    }

    public TickActions putLast(String name, ITickAction action) {
        this.actions.putLast(name, action);
        return this;
    }

    public TickActions remove(String name) {
        this.actions.remove(name);
        return this;
    }

    public TickActions replace(String name, ITickAction action) {
        this.actions.replace(name, action);
        return this;
    }

    public Set<String> keySet() {
        return this.actions.keySet();
    }

    public Collection<ITickAction> values() {
        return this.actions.values();
    }

    public Set<Map.Entry<String, ITickAction>> entrySet() {
        return this.actions.entrySet();
    }

    public static interface ITickAction {
        public boolean perform(BlockState var1, ServerLevel var2, BlockPos var3, BiomeId var4);
    }
}

