/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.sources;

import com.endertech.common.IntBounds;
import com.endertech.minecraft.forge.configs.IHaveConfig;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.world.GameWorld;
import com.endertech.minecraft.forge.world.WorldSearch;
import com.endertech.minecraft.mods.adpother.sources.SourceBase;
import java.util.Collection;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;

public class LavaTouchingWater
extends SourceBase {
    public final EscapeSearchArea escapeSearchArea;

    public LavaTouchingWater(UnitConfig config) {
        super(config, (SourceBase.Properties<?>)((Object)((SourceBase.Properties)((Object)((SourceBase.Properties)((SourceBase.Properties)SourceBase.Properties.of().id("lava")).metaAll()).carbon(0.09f))).sulfur(0.06f)));
        this.escapeSearchArea = new EscapeSearchArea(config, 64, 2);
    }

    @Override
    public void emitAt(Level level, BlockPos pos, float factor) {
        ServerLevel serverLevel;
        if (level instanceof ServerLevel && (serverLevel = (ServerLevel)level).isPositionEntityTicking(pos)) {
            BlockPos above = pos.above();
            if (level.isEmptyBlock(above)) {
                super.emitAt(level, above, factor);
            } else {
                this.escapeSearchArea.findEscapePosition(level, pos).ifPresent(p -> super.emitAt(level, (BlockPos)p, factor));
            }
        }
    }

    public static class EscapeSearchArea
    implements IHaveConfig {
        private final UnitConfig config;
        public final int maxHeight;
        public final int maxRadius;

        public EscapeSearchArea(UnitConfig config, int maxHeight, int maxRadius) {
            this.config = config;
            String category = this.getClassCategory();
            this.maxHeight = UnitConfig.getInt((UnitConfig)config, (String)category, (String)"maxHeight", (int)maxHeight, (IntBounds)IntBounds.between((Integer)0, (Integer)1024), (String)"Maximum height of the search area for emissions to escape");
            this.maxRadius = UnitConfig.getInt((UnitConfig)config, (String)category, (String)"maxRadius", (int)maxRadius, (IntBounds)IntBounds.between((Integer)0, (Integer)64), (String)"Maximum radius of the search area for emissions to escape");
            this.saveConfig();
        }

        public Optional<BlockPos> findEscapePosition(Level level, BlockPos startPos) {
            IntBounds heightBounds = IntBounds.between((Integer)startPos.getY(), (Integer)(startPos.getY() + this.maxHeight - 1));
            WorldSearch.VertCylinder searcher = new WorldSearch.VertCylinder(this, (LevelAccessor)level, startPos, heightBounds, this.maxRadius){

                protected Collection<Direction> getDirections() {
                    Direction[] horizontals = GameWorld.Directions.of().horizontals().shuffle().toArray();
                    return GameWorld.Directions.of().up().add(horizontals).toList();
                }

                protected boolean isValidPath(BlockPos pos) {
                    if (this.level.isEmptyBlock(pos)) {
                        return true;
                    }
                    if (this.lastUsedDirection == null) {
                        return true;
                    }
                    BlockPos last = pos.relative(this.lastUsedDirection.getOpposite());
                    return !this.level.getBlockState(last).isFaceSturdy((BlockGetter)this.level, last, this.lastUsedDirection) && !this.level.getBlockState(pos).isFaceSturdy((BlockGetter)this.level, pos, this.lastUsedDirection.getOpposite());
                }

                protected boolean isValidBlock(BlockPos pos) {
                    return this.level.isEmptyBlock(pos);
                }

                protected boolean onValidFound(BlockPos pos) {
                    return false;
                }
            };
            searcher.build();
            return searcher.getFound().stream().findFirst();
        }

        public UnitConfig getConfig() {
            return this.config;
        }
    }
}

