/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.tiles;

import com.endertech.minecraft.forge.blocks.ForgeBlock;
import com.endertech.minecraft.forge.blocks.IPole;
import com.endertech.minecraft.forge.blocks.ISmokeContainer;
import com.endertech.minecraft.forge.client.RepaintableBlockModel;
import com.endertech.minecraft.forge.entities.ForgeEntity;
import com.endertech.minecraft.forge.items.ForgeItem;
import com.endertech.minecraft.forge.tiles.ForgeTile;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.common.ModConfigSpec;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.util.TriState;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import org.jetbrains.annotations.NotNull;

public class RepaintableBlockTile
extends ForgeTile {
    public static ModConfigSpec.ConfigValue<Boolean> requiresWaterBucket;
    public static ModConfigSpec.ConfigValue<Boolean> requiresDye;
    protected BlockState targetBlock = Blocks.AIR.defaultBlockState();

    public static void onPlayerRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        if (event.getHand() == InteractionHand.MAIN_HAND && !event.getEntity().isShiftKeyDown() && ForgeEntity.hasBrushInHand((LivingEntity)event.getEntity(), InteractionHand.OFF_HAND) && event.getLevel().getBlockEntity(event.getPos()) instanceof RepaintableBlockTile) {
            boolean placeBlock;
            Block block = Block.byItem((Item)event.getEntity().getMainHandItem().getItem());
            boolean bl = placeBlock = block instanceof ISmokeContainer || block instanceof IPole;
            if (!placeBlock) {
                event.setUseItem(TriState.FALSE);
            }
        }
    }

    public RepaintableBlockTile(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @NotNull
    public ModelData getModelData() {
        return ModelData.builder().with(RepaintableBlockModel.BLOCK_STATE, (Object)this.targetBlock).build();
    }

    public void setTargetBlock(BlockState newState) {
        if (this.targetBlock != newState) {
            this.targetBlock = newState;
            this.syncWithClients();
        }
    }

    public BlockState getTargetBlock() {
        return this.targetBlock;
    }

    public InteractionResult tryRepaint(Player player, InteractionHand hand) {
        if (this.level == null || !ForgeEntity.hasBrushInHand((LivingEntity)player, hand)) {
            return InteractionResult.PASS;
        }
        InteractionHand otherHand = ForgeEntity.otherHand(hand);
        BlockState sampleBlock = Block.byItem((Item)player.getItemInHand(otherHand).getItem()).defaultBlockState();
        if (this.getTargetBlock() != sampleBlock && this.isProperSample((BlockGetter)this.level, this.getBlockPos(), sampleBlock) && this.hasAllRequiredMaterials(player)) {
            if (!this.level.isClientSide()) {
                this.setTargetBlock(sampleBlock);
                player.getItemInHand(hand).hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)hand));
                if (((Boolean)requiresDye.get()).booleanValue() && !player.hasInfiniteMaterials()) {
                    Inventory inventory = player.getInventory();
                    ForgeItem.indexIn(inventory, stack -> stack.is(Tags.Items.DYES)).ifPresent(i -> inventory.getItem(i.intValue()).shrink(1));
                }
            }
            this.level.playSound(player, this.getBlockPos(), SoundEvents.BRUSH_GENERIC, SoundSource.BLOCKS);
        }
        return InteractionResult.sidedSuccess((boolean)this.level.isClientSide());
    }

    protected boolean hasAllRequiredMaterials(Player player) {
        if (player.getAbilities().instabuild) {
            return true;
        }
        Inventory inventory = player.getInventory();
        boolean hasWater = (Boolean)requiresWaterBucket.get() == false || ForgeItem.indexIn(inventory, stack -> {
            Item patt0$temp = stack.getItem();
            if (!(patt0$temp instanceof BucketItem)) return false;
            BucketItem bucket = (BucketItem)patt0$temp;
            if (!bucket.content.defaultFluidState().is(FluidTags.WATER)) return false;
            return true;
        }).isPresent();
        boolean hasDye = (Boolean)requiresDye.get() == false || ForgeItem.indexIn(inventory, stack -> stack.is(Tags.Items.DYES)).isPresent();
        return hasWater && hasDye;
    }

    protected boolean isProperSample(BlockGetter level, BlockPos pos, BlockState sample) {
        if (sample.isSolidRender(level, pos)) {
            return true;
        }
        return ForgeBlock.isGlass(sample) && ForgeBlock.isGlass(this.getBlockState());
    }

    @Override
    public void readSharedData(CompoundTag compound, HolderLookup.Provider registries) {
        HolderGetter blockGetter = (HolderGetter)Optional.ofNullable(this.level).map(lvl -> lvl.holderLookup(Registries.BLOCK)).orElse((HolderLookup)BuiltInRegistries.BLOCK.asLookup());
        this.targetBlock = NbtUtils.readBlockState((HolderGetter)blockGetter, (CompoundTag)compound.getCompound("target_block"));
        this.requestModelDataUpdate();
        if (this.level != null && this.level.isClientSide()) {
            this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 2);
        }
    }

    @Override
    public CompoundTag writeSharedData(CompoundTag compound, HolderLookup.Provider registries) {
        if (!this.targetBlock.isAir()) {
            compound.put("target_block", (Tag)NbtUtils.writeBlockState((BlockState)this.targetBlock));
        }
        return compound;
    }
}

