function initializeCoreMod() {
	Java.type('net.neoforged.coremod.api.ASMAPI').loadFile('coremods/core_functions.js')

	var target = {
		'type' : 'METHOD',
		'class' : 'com/simibubi/create/content/kinetics/fan/AirCurrent',
		'methodName' : 'findAffectedHandlers', 
		'methodDesc' : '()V'
	}

	var node = {
		'class' : 'net/minecraft/core/BlockPos',
		'methodName' : 'below',
		'methodDesc' : '(I)Lnet/minecraft/core/BlockPos;'
	}

	var direction = {
		'class' : 'com/simibubi/create/content/kinetics/fan/AirCurrent',
		'fieldName' : 'direction', 
		'fieldDesc' : 'Lnet/minecraft/core/Direction;'
	}

    var pushing = {
		'class' : 'com/simibubi/create/content/kinetics/fan/AirCurrent',
		'fieldName' : 'pushing',
		'fieldDesc' : 'Z'
	}

	var handler = {
		'class' : 'com/endertech/minecraft/mods/adpother/compat/Create',
		'methodName' : 'handleAirCurrent',
		'methodDesc' : '(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/core/Direction;Z)V'
	}

	var instructions = [ 
		insnDup("pos"),
		insnLoadObj(1, "level"),
		insnSwap("level, pos"),
		insnLoadThis("AirCurrent"),
		insnGetField(direction),
		insnLoadThis("AirCurrent"),
        insnGetField(pushing),
		insnCallHandler(handler)
	];

	return {
		'coremod' : {
			'target' : target,
			'transformer' : function(method) {
				insertInstructionsAfter(method, node, instructions);
				return method;
			}
		}
	}
}