function initializeCoreMod() {
	Java.type('net.neoforged.coremod.api.ASMAPI').loadFile('coremods/core_functions.js')

	var target = {
		'type' : 'METHOD',
		'class' : 'electrodynamics/common/tile/electricitygrid/generators/TileCombustionChamber',
		'methodName' : 'tickServer',
		'methodDesc' : '(Lelectrodynamics/prefab/tile/components/type/ComponentTickable;)V'
	}

	var node = {
    	'class' : 'net/neoforged/neoforge/fluids/capability/templates/FluidTank',
    	'methodName' : 'drain',
    	'methodDesc' : '(Lnet/neoforged/neoforge/fluids/FluidStack;Lnet/neoforged/neoforge/fluids/capability/IFluidHandler$FluidAction;)Lnet/neoforged/neoforge/fluids/FluidStack;'
    }
	
	var handler = {
		'class' : 'com/endertech/minecraft/mods/adpother/events/WorldEvents',
		'methodName' : 'onFuelBurned',
		'methodDesc' : '(Lnet/neoforged/neoforge/fluids/FluidStack;Lnet/minecraft/world/level/block/entity/BlockEntity;)V'
	}

	var instructions = [
		insnDup("fuel fluid stack"),
		insnLoadThis("generator tile"),
		insnCallHandler(handler)
	];

	return {
		'coremod' : {
			'target' : target,
			'transformer' : function(method) {
				insertInstructionsAfter(method, node, instructions);
				return method;
			}
		}
	}
}