function initializeCoreMod() {
	Java.type('net.neoforged.coremod.api.ASMAPI').loadFile('coremods/core_functions.js')

	var target = {
		'type' : 'METHOD',
		'class' : 'com/hbm/nucleartech/block/entity/BurnerPressEntity',
		'methodName' : 'consumeFuel',
		'methodDesc' : '()V'
	}

	var node = {
		'class' : 'net/neoforged/neoforge/items/ItemStackHandler',
		'methodName' : 'extractItem', 
		'methodDesc' : '(IIZ)Lnet/minecraft/world/item/ItemStack;'
	}
	
	var handler = {
		'class' : 'com/endertech/minecraft/mods/adpother/events/WorldEvents',
		'methodName' : 'onFuelBurned',
		'methodDesc' : '(Lnet/minecraft/world/item/ItemStack;ILnet/minecraft/world/level/block/entity/BlockEntity;)V'
	}

	var instructions = [
		insnDup("fuel stack"),
		insnPushValue(1, "fuel amount"),
		insnLoadThis("burner press"),
		insnCallHandler(handler)
	];

	return {
		'coremod' : {
			'target' : target,
			'transformer' : function(method) {
				insertInstructionsAfter(method, node, instructions);
				return method;
			}
		}
	}
}