function initializeCoreMod() {
	Java.type('net.neoforged.coremod.api.ASMAPI').loadFile('coremods/core_functions.js')

	var target = {
		'type': 'METHOD',
		'class': 'immersive_aircraft/entity/EngineVehicle',
		'methodName': 'm_8119_', // tick
		'methodDesc': '()V'
	}

	var node = {
		'class': 'immersive_aircraft/entity/EngineVehicle',
		'methodName': 'consumeFuel',
		'methodDesc': '(F)F'
	}

	var handler = {
		'class': 'com/endertech/minecraft/mods/adpother/compat/ImmersiveAircraft$Vehicle',
		'methodName': 'onFuelBurned',
		'methodDesc': '(FLnet/minecraft/world/entity/Entity;)V'
	}

	var instructions = [
		insnDup("consumed fuel amount"),
		insnLoadThis("vehicle"),
		insnCallHandler(handler)
	];

	return {
		'coremod': {
			'target': target,
			'transformer': function(method) {
				insertInstructionsBefore(method, node, instructions);
				return method;
			}
		}
	}
}