function initializeCoreMod() {
	Java.type('net.neoforged.coremod.api.ASMAPI').loadFile('coremods/core_functions.js')

	var target = {
		'type' : 'METHOD',
		'class' : 'immersive_aircraft/entity/weapon/BulletWeapon',
		'methodName' : 'spentAmmo',
		'methodDesc' : '(Ljava/util/Map;I)Z'
	}

	var node = {
		'class' : 'net/minecraft/world/item/ItemStack',
		'methodName' : resolveName('m_41774_'), // shrink 
		'methodDesc' : '(I)V'
	}

    var getEntity = {
		'class': 'immersive_aircraft/entity/weapon/BulletWeapon',
		'methodName': 'getEntity',
		'methodDesc': '()Limmersive_aircraft/entity/VehicleEntity;'
	}

    var handler = {
		'class': 'com/endertech/minecraft/mods/adpother/compat/ImmersiveAircraft$Vehicle',
		'methodName': 'onAmmoSpent',
		'methodDesc': '(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/entity/Entity;)V'
	}

	var instructions = [
		insnLoadThis("weapon"),
		insnInvokeVirtual(getEntity),
		insnCallHandler(handler)
	];

	return {
		'coremod' : {
			'target' : target,
			'transformer' : function(method) {
			    insertInstructionsBefore(method, node, [].concat(instructionsDupValue2("ammo stack"), instructions));
				return method;
			}
		}
	}
}