function initializeCoreMod() {
	Java.type('net.neoforged.coremod.api.ASMAPI').loadFile('coremods/core_functions.js')

	var target = {
		'type': 'METHOD',
		'class': 'flaxbeard/immersivepetroleum/common/entity/MotorboatEntity',
		'methodName': 'controlBoat',
		'methodDesc': '()V'
	}

	var node = {
		'class': 'flaxbeard/immersivepetroleum/common/entity/MotorboatEntity',
		'methodName': 'setContainedFluid',
		'methodDesc': '(Lnet/neoforged/neoforge/fluids/FluidStack;)V'
	}

    var getTank = {
    	'class': 'flaxbeard/immersivepetroleum/common/entity/MotorboatEntity',
    	'methodName': 'getTank',
    	'methodDesc': '()Lnet/neoforged/neoforge/fluids/IFluidTank;'
    }

    var getFluid = {
    	'class': 'net/neoforged/neoforge/fluids/IFluidTank',
    	'methodName': 'getFluid',
    	'methodDesc': '()Lnet/neoforged/neoforge/fluids/FluidStack;'
    }

	var handler = {
		'class': 'com/endertech/minecraft/mods/adpother/compat/ImmersivePetroleum$Motorboat',
		'methodName': 'onFuelBurned',
		'methodDesc': '(Lnet/minecraft/world/entity/Entity;Lnet/neoforged/neoforge/fluids/FluidStack;I)V'
	}

	var alignment = {
		'class': 'com/endertech/minecraft/mods/adpother/events/WorldEvents$Alignment',
		'fieldName': 'CENTER',
		'fieldDesc': 'Lcom/endertech/minecraft/mods/adpother/events/WorldEvents$Alignment;'
	}

	var instructions = [
		insnDup2("boat, fuelNow"),
		insnLoadInt(5, "consumed"),
		insnCallHandler(handler)
	];

	return {
		'coremod': {
			'target': target,
			'transformer': function(method) {
				insertInstructionsBefore(method, node, instructions);
				return method;
			}
		}
	}
}