function initializeCoreMod() {
	Java.type('net.neoforged.coremod.api.ASMAPI').loadFile('coremods/core_functions.js')

	var target = {
		'type' : 'METHOD',
		'class' : 'com/buuz135/industrial/block/generator/mycelial/MagmaGeneratorType',
		'methodName' : 'getTimeAndPowerGeneration',
		'methodDesc' : '([Lnet/neoforged/neoforge/common/util/INBTSerializable;)Lorg/apache/commons/lang3/tuple/Pair;'
	}

	var node = {
		'class' : 'com/hrznstudio/titanium/component/fluid/SidedFluidTankComponent',
		'methodName' : 'drainForced',
		'methodDesc' : '(ILnet/neoforged/neoforge/fluids/capability/IFluidHandler$FluidAction;)Lnet/neoforged/neoforge/fluids/FluidStack;'
	}
	
	var handler = {
		'class' : 'com/endertech/minecraft/mods/adpother/events/WorldEvents',
		'methodName' : 'onFuelBurned',
		'methodDesc' : '(Lnet/neoforged/neoforge/fluids/FluidStack;Lnet/minecraft/world/level/block/entity/BlockEntity;)V'
	}

	var instructions = [ 
		insnDup("consumed fuel fluidstack"),
		insnLoadThis("magma generator tile"),
		insnCallHandler(handler)
	];

	return {
		'coremod' : {
			'target' : target,
			'transformer' : function(method) {
				insertInstructionsAfter(method, node, instructions);
				return method;
			}
		}
	}
}