function initializeCoreMod() {
	Java.type('net.neoforged.coremod.api.ASMAPI').loadFile('coremods/core_functions.js')

	var target = {
		'type' : 'METHOD',
		'class' : 'dev/murad/shipping/entity/custom/vessel/tug/SteamTugEntity',
		'methodName' : 'tickFuel',
		'methodDesc' : '()Z'
	}

	var node = {
   		'class' : 'net/minecraft/world/item/ItemStack',
   		'methodName' : 'shrink',
   		'methodDesc' : '(I)V'
   	}
	
	var handler = {
		'class' : 'com/endertech/minecraft/mods/adpother/events/WorldEvents',
		'methodName' : 'onFuelBurned',
		'methodDesc' : '(Lnet/minecraft/world/item/ItemStack;ILnet/minecraft/world/entity/Entity;Lcom/endertech/minecraft/mods/adpother/events/WorldEvents$Alignment;)V'
	}

	var alignment = {
		'class' : 'com/endertech/minecraft/mods/adpother/events/WorldEvents$Alignment',
		'fieldName' : 'CENTER',
		'fieldDesc' : 'Lcom/endertech/minecraft/mods/adpother/events/WorldEvents$Alignment;'
	}

	var instructions = [
		insnPushValue(1, "fuel amount"),
		insnLoadThis("steam tug"),
		insnGetStatic(alignment),
		insnCallHandler(handler)
	];

	return {
		'coremod' : {
			'target' : target,
			'transformer' : function(method) {
				insertInstructionsBefore(method, node, [].concat(instructionsDupValue2("fuel itemstack"), instructions));
				return method;
			}
		}
	}
}