function initializeCoreMod() {
	Java.type('net.neoforged.coremod.api.ASMAPI').loadFile('coremods/core_functions.js')

	var target = {
		'type' : 'METHOD',
		'class' : 'net/minecraft/world/entity/projectile/FireworkRocketEntity',
		'methodName' : 'explode',
		'methodDesc' : '(Lnet/minecraft/server/level/ServerLevel;)V'
	}

	var getExplosions = {
		'class' : 'net/minecraft/world/entity/projectile/FireworkRocketEntity',
		'methodName' : 'getExplosions',
		'methodDesc' : '()Ljava/util/List;'
	}
	
	var handler = {
		'class' : 'com/endertech/minecraft/mods/adpother/compat/Minecraft',
		'methodName' : 'handleFireworkExplosion',
		'methodDesc' : '(Lnet/minecraft/world/entity/projectile/FireworkRocketEntity;Ljava/util/List;)V'
	}

	var instructions = [ 
		insnLoadThis("firework rocket entity"),
		insnLoadThis("firework rocket entity"),
		insnInvokeVirtual(getExplosions),
		insnCallHandler(handler)
	];

	return {
		'coremod' : {
			'target' : target,
			'transformer' : function(method) {
				insertInstructionsBeforeAll(method, instructions);
				return method;
			}
		}
	}
}