function initializeCoreMod() {
	Java.type('net.neoforged.coremod.api.ASMAPI').loadFile('coremods/core_functions.js')

	var target = {
		'type' : 'METHOD',
		'class' : 'com/blakebr0/mysticalagriculture/tileentity/ReprocessorTileEntity',
		'methodName' : 'tick',
		'methodDesc' : '(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;Lcom/blakebr0/mysticalagriculture/tileentity/ReprocessorTileEntity;)V'
	}

	var node = {
		'class' : 'com/blakebr0/cucumber/inventory/BaseItemStackHandler',
		'methodName' : 'extractItemSuper',
		'methodDesc' : '(IIZ)Lnet/minecraft/world/item/ItemStack;'
	}
			
	var handler = {
		'class' : 'com/endertech/minecraft/mods/adpother/events/WorldEvents',
		'methodName' : 'onFuelBurned',
		'methodDesc' : '(Lnet/minecraft/world/item/ItemStack;ILnet/minecraft/world/level/block/entity/BlockEntity;)V'
	}

	var instructions = [
	    insnDup("fuel"),
		insnPushValue(1, "fuel amount"),
		insnLoadObj(3, "tile"),
		insnCallHandler(handler)
	];

	return {
		'coremod' : {
			'target' : target,
			'transformer' : function(method) {
				insertInstructionsAfter(method, node, instructions);
				return method;
			}
		}
	}
}