function initializeCoreMod() {
	Java.type('net.neoforged.coremod.api.ASMAPI').loadFile('coremods/core_functions.js')

	var target = {
		'type': 'METHOD',
		'class': 'com/talhanation/smallships/world/entity/projectile/Cannon',
		'methodName': 'shoot',
		'methodDesc': '(Lnet/minecraft/world/phys/Vec3;DLnet/minecraft/world/entity/LivingEntity;DD)V'
	}

	var node = {
    		'type': 'METHOD',
    		'class': 'net/minecraft/world/level/Level',
    		'methodName': 'addFreshEntity',
    		'methodDesc': '(Lnet/minecraft/world/entity/Entity;)Z'
   	}

	var handler = {
		'class': 'com/endertech/minecraft/mods/adpother/compat/SmallShips$CannonBall',
		'methodName': 'onFired',
		'methodDesc': '(Lnet/minecraft/world/entity/Entity;)V'
	}

	var instructions = [
		insnDup("cannon ball entity"),
		insnCallHandler(handler)
	];

	return {
		'coremod': {
			'target': target,
			'transformer': function(method) {
				insertInstructionsBefore(method, node, instructions);
				return method;
			}
		}
	}
}