/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.blocks;

import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.world.BiomeId;
import com.endertech.minecraft.mods.adpother.blocks.AbstractGas;
import com.endertech.minecraft.mods.adpother.blocks.Pollutant;
import com.endertech.minecraft.mods.adpother.pollution.DustLayer;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;

public class Dust
extends AbstractGas {
    private final DustLayer.Property<BiomeId> dustLayer;

    public Dust(UnitConfig config, String name) {
        super(config, (AbstractGas.Properties<?>)((Object)((AbstractGas.Properties)((Object)((Pollutant.Properties)((Object)((AbstractGas.Properties)((Object)((AbstractGas.Properties)((Object)((AbstractGas.Properties)((Object)((AbstractGas.Properties)((Object)AbstractGas.Properties.of(name, MapColor.f_283779_).criticalAmount(512))).concentrationAltitude(-65))).motionVelocity(0.1f))).absorbtionChance(80))).lowerExplosiveLimit(20))).textColor(ChatFormatting.WHITE))).neverAffectChunkPollution()));
        this.filterMaterials.addDefaultValues(new String[]{"paper, 8, gray_dye"});
        String category = name;
        this.dustLayer = DustLayer.Property.create(config, category, "layeredBlock", DustLayer.DEFAULT, "Defines whether dust can settle and turn into a layered block.\nSyntax: blockId, layersRange\n");
        this.addBiomeIdProperties(this.dustLayer);
        this.tickActions.put("trySettleAsLayer", this::trySettleAsLayer);
    }

    public DustLayer getDustLayer(BiomeId biome) {
        return (DustLayer)this.dustLayer.get(biome);
    }

    public boolean trySettleAsLayer(BlockState state, ServerLevel level, BlockPos pos, BiomeId biome) {
        BlockState newState;
        BlockState blockBelow;
        DustLayer layer = this.getDustLayer(biome);
        if (layer.isSameBlock(blockBelow = level.m_8055_(pos.m_7495_())) && (newState = layer.withAddedLayer(blockBelow)) != blockBelow) {
            return level.m_46597_(pos.m_7495_(), newState) && this.spend((LevelAccessor)level, pos);
        }
        int layers = layer.layerBounds.getMin() + Math.max(0, this.getCarriedPollutionAmount(state) - 1);
        Optional<BlockState> layeredBlock = layer.asLayeredBlock(layers);
        return layeredBlock.isPresent() && layeredBlock.get().m_60710_((LevelReader)level, pos) && level.m_7471_(pos, false) && level.m_46597_(pos, layeredBlock.get());
    }
}

