/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.compat;

import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.data.TagHelper;
import com.endertech.minecraft.mods.adpother.AdPother;
import com.endertech.minecraft.mods.adpother.events.WorldEvents;
import com.endertech.minecraft.mods.adpother.sources.Emitter;
import com.endertech.minecraft.mods.adpother.sources.Fuel;
import com.endertech.minecraft.mods.adpother.sources.SourceBase;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.INBTSerializable;

public class ImmersiveAircraft {
    public static Emitter.Properties<?> vehicle() {
        return Emitter.Properties.fuel("").customFactory(Vehicle::new);
    }

    public static class Vehicle
    extends Emitter {
        public static final void onFuelBurned(float amount, Entity entity) {
            Emitter emitter;
            if (amount > 0.0f && (emitter = (Emitter)AdPother.getInstance().emitters.get(entity).orElse(null)) != null && emitter.isActive((INBTSerializable<CompoundTag>)entity)) {
                Fuel fuel = new Fuel(null, (SourceBase.Properties<?>)((Object)((SourceBase.Properties)((Object)((SourceBase.Properties)((Object)Emitter.Properties.of().factor(amount * 1.0f / 1600.0f))).carbon(1.0f))).sulfur(0.1f)), false);
                WorldEvents.onFuelBurned(fuel, 5, entity, WorldEvents.Alignment.BACK);
            }
        }

        public static final void onAmmoSpent(ItemStack ammo, Entity entity) {
            Level level = entity.m_9236_();
            BlockPos pos = BlockPos.m_274446_((Position)WorldEvents.Alignment.CENTER.getPositionVec(entity));
            ItemStack stack = new ItemStack((ItemLike)ammo.m_41720_(), 1);
            WorldEvents.onItemBurned(stack, level, pos);
        }

        public Vehicle(UnitConfig config, Emitter.Properties<?> props) {
            super(config, (Emitter.Properties<?>)((Object)props.activeStateHardcoded()));
        }

        @Override
        public boolean isActive(INBTSerializable<CompoundTag> nbtSource) {
            if (nbtSource != null) {
                try {
                    String key;
                    CompoundTag compound = TagHelper.serialize(nbtSource);
                    int i = 0;
                    while (compound.m_128441_(key = "Fuel" + i)) {
                        if (compound.m_128451_(key) > 0) {
                            return true;
                        }
                        ++i;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return false;
        }
    }
}

