/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.entities;

import com.endertech.minecraft.forge.entities.BlockStateCarrier;
import com.endertech.minecraft.mods.adpother.blocks.Pollutant;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public abstract class AbstractCarrier
extends BlockStateCarrier {
    public AbstractCarrier(EntityType<?> type, Level world, BlockPos pos, BlockState carriedState) {
        super(type, world, pos, carriedState);
        if (world instanceof ServerLevel) {
            ((ServerLevel)world).m_8886_();
        }
    }

    public AbstractCarrier(EntityType<?> type, Level world) {
        super(type, world);
    }

    public Optional<Pollutant<?>> getPollutant() {
        return this.getCarriedBlockState().map(state -> state.m_60734_()).filter(block -> block instanceof Pollutant).map(block -> (Pollutant)((Object)block));
    }

    public boolean m_5829_() {
        return false;
    }

    public int getPollutionAmount() {
        return this.getCarriedBlockState().flatMap(state -> this.getPollutant().map(pollutant -> pollutant.getCarriedPollutionAmount((BlockState)state))).orElse(0);
    }

    public int getPollutionCapacity() {
        return this.getPollutant().map(Pollutant::getPollutionCapacity).orElse(0);
    }

    public boolean pump() {
        Pollutant pollutant;
        BlockState state;
        if (this.isServerSide() && this.m_6084_() && (state = (BlockState)this.getCarriedBlockState().orElse(null)) != null && (pollutant = (Pollutant)this.getPollutant().orElse(null)) != null && pollutant.canStateBePumped(state)) {
            this.setCarriedBlockState(Optional.of(pollutant.getPumpedState(state)));
            return true;
        }
        return false;
    }

    public boolean spend() {
        Pollutant pollutant;
        BlockState state;
        if (this.isServerSide() && this.m_6084_() && (state = (BlockState)this.getCarriedBlockState().orElse(null)) != null && (pollutant = (Pollutant)this.getPollutant().orElse(null)) != null && pollutant.canStateBeSpreaded(state)) {
            this.setCarriedBlockState(Optional.of(pollutant.getSpreadedState(state)));
            return true;
        }
        return false;
    }

    protected boolean spreadTo(AbstractCarrier targetEntity, int minPollutionDelta) {
        if (targetEntity.m_6084_() && targetEntity.carriesSameBlock(this.getPollutant())) {
            int pollutionDelta = Math.abs(this.getPollutionAmount() - targetEntity.getPollutionAmount());
            return pollutionDelta >= minPollutionDelta && targetEntity.pump();
        }
        return false;
    }

    protected void setCarriedBlockState(Optional<BlockState> newState) {
        super.setCarriedBlockState(newState);
        if (newState.isPresent() && newState.get().m_60795_() && this.isServerSide()) {
            this.m_146870_();
        }
    }

    public static enum SpawnTime {
        NOW,
        LATER,
        NEVER;

    }
}

