/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.events;

import com.endertech.minecraft.forge.items.RepairMatcher;
import com.endertech.minecraft.mods.adpother.AdPother;
import com.endertech.minecraft.mods.adpother.blocks.FilterFrame;
import com.endertech.minecraft.mods.adpother.blocks.Pollutant;
import com.endertech.minecraft.mods.adpother.init.Pollutants;
import com.endertech.minecraft.mods.adpother.init.Respirators;
import com.endertech.minecraft.mods.adpother.items.VacuumBag;
import com.endertech.minecraft.mods.adpother.pollution.IStorageItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.event.entity.player.AnvilRepairEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="adpother")
public class AnvilEvents {
    public static ForgeConfigSpec.ConfigValue<Integer> filterReplacingExpGain;

    @SubscribeEvent
    public static void onVacuumBagPlaced(AnvilUpdateEvent event) {
        Item item = event.getLeft().m_41720_();
        if (item instanceof VacuumBag) {
            VacuumBag vacuumBag = (VacuumBag)item;
            AnvilEvents.cleanAndPrepare(vacuumBag, 1, event);
        }
    }

    @SubscribeEvent
    public static void onRespiratorPlaced(AnvilUpdateEvent event) {
        ItemStack stack = event.getLeft();
        Respirators.Respirator respirator = AdPother.getInstance().respirators.get(stack).orElse(null);
        if (respirator == null) {
            return;
        }
        AnvilEvents.cleanAndPrepare(respirator, 1, event);
    }

    @SubscribeEvent
    public static void onRepair(AnvilRepairEvent event) {
        ItemStack stack = event.getLeft();
        Item item = stack.m_41720_();
        if (item instanceof VacuumBag || Block.m_49814_((Item)item) instanceof FilterFrame || AdPother.getInstance().respirators.get(stack).isPresent()) {
            event.setBreakChance(0.0f);
            event.getEntity().m_6749_((Integer)filterReplacingExpGain.get() + 1);
        }
    }

    private static boolean cleanAndPrepare(IStorageItem storage, int materialCost, AnvilUpdateEvent event) {
        RepairMatcher matcher = RepairMatcher.from((AnvilUpdateEvent)event);
        Pollutants pollutants = AdPother.getInstance().pollutants;
        if (matcher.material.m_41613_() < materialCost) {
            return false;
        }
        ItemStack output = event.getLeft().m_41777_();
        boolean result = false;
        for (Pollutant pollutant : pollutants.streamAll().toList()) {
            if (!pollutant.getFilterMaterials().contains(matcher.material)) continue;
            storage.installFiltersFor(output, pollutant);
            event.setCost(1);
            event.setMaterialCost(materialCost);
            event.setOutput(output);
            result = true;
        }
        return result;
    }
}

