/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.impacts;

import com.endertech.common.Args;
import com.endertech.minecraft.forge.configs.ConfigCategory;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.math.Percentage;
import com.endertech.minecraft.mods.adpother.AdPother;
import com.endertech.minecraft.mods.adpother.blocks.Pollutant;
import com.endertech.minecraft.mods.adpother.config.BlockImpactList;
import com.endertech.minecraft.mods.adpother.impacts.AbstractPollutionImpacts;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.util.Lazy;

public class EnvironmentalImpacts
extends AbstractPollutionImpacts<BlockImpactList> {
    public EnvironmentalImpacts(UnitConfig config) {
        super(config);
        config.setCategoryComment(this.getHeadCategory(), "Action syntax: blockId -> ACTION\nReplacement syntax: blockId -> blockId\nReplacement with copying of all properties: blockId -> blockId:*\nSyntax with a threshold: pollutionThreshold% -> blockId -> ACTION or blockId\n\nPollution threshold is the minimum percentage of pollution to trigger the specified effect\n\nId is a basic unit (block or item) identifier in <modId:unitName:meta> format.\nModId can be omitted for vanilla items. Meta can be omitted too if it equals 0.\nUnitName must be lowercase, words separated by '_', words order - from private to common (example: black_iron_ore).\nUse '*' char or '[]' as meta value to specify all possible values (all block states).\nTo define multiple block states, you can use block properties. The format is <modId:blockName:[prop1=value1, prop2=value2]>\nAlso you may use tags. The format is <#modId:tagPath> (example: #forge:ores/copper).\n\nPossible actions (case sensitive): " + Args.join((Object[])Arrays.stream(BlockImpactList.ActionType.values()).filter(type -> type != BlockImpactList.ActionType.REPLACE).toArray()));
        AdPother.getInstance().pollutants.mapAll().forEach((name, pollutant) -> {
            String category = ConfigCategory.name().join(new String[]{this.getHeadCategory(), name});
            EnumMap<AbstractPollutionImpacts.ImpactType, BlockImpactList> impactsBySpread = new EnumMap<AbstractPollutionImpacts.ImpactType, BlockImpactList>(AbstractPollutionImpacts.ImpactType.class);
            for (AbstractPollutionImpacts.ImpactType type : AbstractPollutionImpacts.ImpactType.values()) {
                impactsBySpread.put(type, new BlockImpactList(config, category, type.getName(), "Effects spreading through " + type.getName() + "."));
            }
            this.impactsByPollutant.put((Pollutant)((Object)((Object)pollutant.get())), impactsBySpread);
        });
        this.carbon(AbstractPollutionImpacts.ImpactType.CONTACT, "minecraft:water:* -> POLLUTE", "#minecraft:cave_vines -> BONEMEAL", "#minecraft:leaves -> KILL");
        this.carbon(AbstractPollutionImpacts.ImpactType.RAIN, "minecraft:grass_block:* -> BONEMEAL", "minecraft:moss_block:* -> BONEMEAL", "minecraft:sweet_berry_bush:* -> BONEMEAL", "#minecraft:leaves -> BONEMEAL", "#minecraft:tall_flowers -> BONEMEAL");
        this.carbon(AbstractPollutionImpacts.ImpactType.AIR, "minecraft:bamboo:* -> BONEMEAL", "minecraft:big_dripleaf:* -> BONEMEAL", "agricraft:crop:* -> BONEMEAL", "minecraft:fern:* -> BONEMEAL", "minecraft:grass:* -> BONEMEAL", "minecraft:kelp:* -> BONEMEAL", "minecraft:seagrass:* -> BONEMEAL", "minecraft:short_grass:* -> BONEMEAL", "#minecraft:crops -> BONEMEAL", "#minecraft:saplings -> BONEMEAL");
        this.dust(AbstractPollutionImpacts.ImpactType.CONTACT, "agricraft:crop:* -> KILL", "minecraft:water:* -> POLLUTE", "minecraft:fern:* -> KILL", "minecraft:grass:* -> KILL", "minecraft:dirt_path:* -> minecraft:coarse_dirt", "minecraft:farmland:* -> minecraft:coarse_dirt", "minecraft:grass_block:* -> minecraft:dirt_path", "minecraft:rooted_dirt:* -> minecraft:coarse_dirt", "minecraft:short_grass:* -> KILL", "#minecraft:crops -> KILL", "#minecraft:saplings -> KILL", "#minecraft:small_flowers -> KILL", "farmersdelight:rich_soil:* -> minecraft:coarse_dirt", "farmersdelight:rich_soil_farmland:* -> minecraft:coarse_dirt");
        this.dust(AbstractPollutionImpacts.ImpactType.RAIN, "minecraft:coarse_dirt:* -> minecraft:gravel");
        this.sulfur(AbstractPollutionImpacts.ImpactType.CONTACT, "minecraft:water:* -> POLLUTE", "#minecraft:cave_vines -> KILL", "#minecraft:leaves -> KILL");
        this.sulfur(AbstractPollutionImpacts.ImpactType.RAIN, "minecraft:bamboo:* -> KILL", "minecraft:big_dripleaf:* -> KILL", "minecraft:dirt_path:* -> minecraft:podzol", "minecraft:farmland:* -> minecraft:podzol", "minecraft:grass_block:* -> minecraft:podzol", "minecraft:large_fern:* -> KILL", "minecraft:moss_block:* -> minecraft:podzol", "minecraft:rooted_dirt:* -> minecraft:coarse_dirt", "minecraft:sugar_cane:* -> KILL", "minecraft:sweet_berry_bush:* -> KILL", "minecraft:tall_grass:* -> KILL", "minecraft:water:* -> POLLUTE", "#minecraft:leaves -> KILL", "#minecraft:tall_flowers -> KILL", "10% -> minecraft:bee_nest:* -> KILL", "10% -> minecraft:melon:* -> KILL", "10% -> minecraft:pumpkin:* -> KILL", "15% -> minecraft:stone -> minecraft:cobblestone", "20% -> minecraft:hay_block:* -> KILL", "30% -> minecraft:mangrove_roots:* -> KILL", "farmersdelight:rich_soil:* -> minecraft:podzol", "farmersdelight:rich_soil_farmland:* -> minecraft:podzol");
        this.sulfur(AbstractPollutionImpacts.ImpactType.AIR, "minecraft:cactus:* -> KILL", "minecraft:fern:* -> KILL", "minecraft:grass:* -> KILL", "minecraft:moss_carpet:* -> KILL", "minecraft:short_grass:* -> KILL", "#minecraft:crops -> KILL", "#minecraft:saplings -> KILL", "#minecraft:small_flowers -> KILL", "agricraft:crop:* -> KILL");
    }

    public List<BlockImpactList.AbstractAction> getActionsFor(BlockState state, Pollutant<?> pollutant, AbstractPollutionImpacts.ImpactType type) {
        return this.getImpactsFor(pollutant, type).map(impacts -> impacts.getActionsFor(state)).orElse(Collections.emptyList());
    }

    public boolean canAffect(BlockState state, Pollutant<?> pollutant, AbstractPollutionImpacts.ImpactType type) {
        return !this.getActionsFor(state, pollutant, type).isEmpty();
    }

    public boolean tryAffect(ServerLevel world, BlockPos pos, BlockState state, Pollutant<?> pollutant, AbstractPollutionImpacts.ImpactType type) {
        List<BlockImpactList.AbstractAction> actions = this.getActionsFor(state, pollutant, type);
        if (actions.isEmpty()) {
            return false;
        }
        Lazy chunkPollution = Lazy.of(() -> pollutant.getPercentageAtChunk(world, pos));
        for (BlockImpactList.AbstractAction action : actions) {
            if (!action.threshold.equals((Object)Percentage.ZERO) && !action.threshold.isLessOrEqualTo((Object)((Percentage)chunkPollution.get()))) continue;
            return action.perform(world, pos, state);
        }
        return false;
    }
}

